/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.be.model.bodystatus;

import cn.lollypop.be.model.bodystatus.BodyStatusDetail;

public class ExerciseInfo
extends BodyStatusDetail {
    private int type;
    private int strength;
    private int inheritedExerciseTypes = 0;
    private String custom;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getInheritedExerciseTypes() {
        return this.inheritedExerciseTypes;
    }

    public void setInheritedExerciseType(int inheritedExerciseType) {
        this.inheritedExerciseTypes |= inheritedExerciseType;
    }

    public String getCustom() {
        return this.custom;
    }

    public void setCustom(String custom) {
        this.custom = custom;
        this.inheritedExerciseTypes = custom != null ? (this.inheritedExerciseTypes |= InheritedExerciseType.CUSTOM.getValue()) : (this.inheritedExerciseTypes &= ~InheritedExerciseType.CUSTOM.getValue());
    }

    public boolean hasCustom() {
        return (this.inheritedExerciseTypes & InheritedExerciseType.CUSTOM.getValue()) != 0 && this.custom != null;
    }

    public String toString() {
        return "ExerciseInfo{type=" + this.type + ", strength=" + this.strength + ", inheritedExerciseTypes=" + this.inheritedExerciseTypes + (this.hasCustom() ? ", custom=" + this.custom : "") + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InheritedExerciseType {
        UNKNOWN(0),
        WALKING(1),
        SWIMMING(2),
        BALL_GAMES(4),
        RUNNING(8),
        YOGA(16),
        BIKING(32),
        HIKING(64),
        DANCING(128),
        GYM(256),
        CUSTOM(512);

        private final int value;

        private InheritedExerciseType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strength {
        UNKNOWN(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        private final int value;

        private Strength(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExerciseType {
        UNKNOWN(0),
        WALKING(1),
        RUNNING(2),
        SWIMMING(3),
        YOGA(4),
        BALL_GAMES(5),
        GYM(6);

        private final int value;

        private ExerciseType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

