/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.be.model.bodystatus;

import cn.lollypop.be.model.bodystatus.BodyStatusDetail;

public class Emotions
extends BodyStatusDetail {
    private int type;
    private int inheritedTypes = 0;
    private String custom;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getInheritedTypes() {
        return this.inheritedTypes;
    }

    public void setInheritedType(int inheritedType) {
        this.inheritedTypes |= inheritedType;
    }

    public String getCustom() {
        return this.custom;
    }

    public void setCustom(String custom) {
        this.custom = custom;
        this.inheritedTypes = custom != null ? (this.inheritedTypes |= InheritedEmotionType.CUSTOM.getValue()) : (this.inheritedTypes &= ~InheritedEmotionType.CUSTOM.getValue());
    }

    public boolean hasCustom() {
        return (this.inheritedTypes & InheritedEmotionType.CUSTOM.getValue()) != 0 && this.custom != null;
    }

    public String toString() {
        return "Emotions{type=" + this.type + ", inheritedTypes=" + this.inheritedTypes + (this.hasCustom() ? ", custom=" + this.custom : "") + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InheritedEmotionType {
        UNKNOWN(0),
        CALM(1),
        HAPPY(2),
        FRISKY(4),
        EMOTIONAL(8),
        MOOD_SWINGS(16),
        ANXIOUS(32),
        SAD(64),
        IRRITABLE(128),
        ANGRY(256),
        CUSTOM(512);

        private final int value;

        private InheritedEmotionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmotionType {
        UNKNOWN(0),
        HAPPY(1),
        CALM(2),
        DISTRESSED(3),
        IRRITABLE(4),
        ANXIOUS(5),
        ANGRY(6);

        private final int value;

        private EmotionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

