/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.be.model.bodystatus;

import cn.lollypop.be.model.bodystatus.AlcoholInfo;
import cn.lollypop.be.model.bodystatus.BodyStatusDetail;
import cn.lollypop.be.model.bodystatus.CervicalMucus;
import cn.lollypop.be.model.bodystatus.DailyNotes;
import cn.lollypop.be.model.bodystatus.Emotions;
import cn.lollypop.be.model.bodystatus.ExerciseInfo;
import cn.lollypop.be.model.bodystatus.MedicationInfo;
import cn.lollypop.be.model.bodystatus.MenstruationInfo;
import cn.lollypop.be.model.bodystatus.OvulationInfo;
import cn.lollypop.be.model.bodystatus.OvulationTestResult;
import cn.lollypop.be.model.bodystatus.PhysicalSymptoms;
import cn.lollypop.be.model.bodystatus.SexInfo;
import cn.lollypop.be.model.bodystatus.SleepInfo;
import cn.lollypop.be.model.bodystatus.SpottingInfo;
import cn.lollypop.be.model.bodystatus.WeightInfo;
import java.util.Calendar;

public class BodyStatus {
    private static final int DAY_SECONDS = 86400;
    private int timestamp;
    private StatusType type;
    @Deprecated
    private int value;
    @Deprecated
    private String description;
    private String detail;
    private int insertTime;

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public StatusType getType() {
        return this.type;
    }

    public void setType(StatusType type) {
        this.type = type;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public static int normalizeTimestamp(int timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(1000L * (long)timestamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return (int)(calendar.getTimeInMillis() / 1000L);
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public int getInsertTime() {
        return this.insertTime;
    }

    public void setInsertTime(int insertTime) {
        this.insertTime = insertTime;
    }

    public String toString() {
        return "BodyStatus{timestamp=" + this.timestamp + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + ", description='" + this.description + '\'' + ", detail='" + this.detail + '\'' + ", insertTime=" + this.insertTime + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusType {
        UNKNOWN(0, BodyStatusDetail.class),
        SEX(1, SexInfo.class),
        FEVER(2, BodyStatusDetail.class),
        MUCUS(4, CervicalMucus.class),
        CRAMPS(8, BodyStatusDetail.class),
        PILL(16, MedicationInfo.class),
        PERIOD(32, MenstruationInfo.class),
        ALCOHOL(64, AlcoholInfo.class),
        EMOTIONS(128, Emotions.class),
        EXERCISE(256, ExerciseInfo.class),
        OVULATION_TEST(512, OvulationTestResult.class),
        PHYSICAL_SYMPTOMS(1024, PhysicalSymptoms.class),
        SLEEP(2048, SleepInfo.class),
        DAILY_NOTES(4096, DailyNotes.class),
        SPOTTING(8192, SpottingInfo.class),
        WEIGHT(16384, WeightInfo.class),
        OVULATION(32768, OvulationInfo.class);

        private final int type;
        private final Class<? extends BodyStatusDetail> detailClazz;

        private StatusType(int type, Class<? extends BodyStatusDetail> clazz) {
            this.type = type;
            this.detailClazz = clazz;
        }

        public int getType() {
            return this.type;
        }

        public Class<? extends BodyStatusDetail> getDetailClazz() {
            return this.detailClazz;
        }

        public static StatusType fromInt(int type) {
            for (StatusType t : StatusType.values()) {
                if (t.getType() != type) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

