/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AnalyticsImpl;
import com.avos.avoscloud.AnalyticsRequestController;
import com.avos.avoscloud.BasicAnalyticsRequestDispatcher;
import com.avos.avoscloud.LogUtil;

class RealTimeRequestController
extends BasicAnalyticsRequestDispatcher {
    static final int REQUEST_FOR_SEND = 19141010;
    static final int REQUEST_END_SEND = 20141010;
    private final Handler reportRequestDispatcher = new Handler(Looper.getMainLooper()){
        boolean hasRequestForSend;
        boolean hasRequestSending;
        {
            this.hasRequestForSend = false;
            this.hasRequestSending = false;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 19141010: {
                    if (this.hasRequestSending) {
                        this.hasRequestForSend = true;
                        break;
                    }
                    RealTimeRequestController.this.asyncHandler.sendEmptyMessage(19141010);
                    this.hasRequestSending = true;
                    break;
                }
                case 20141010: {
                    if (this.hasRequestForSend) {
                        RealTimeRequestController.this.asyncHandler.sendEmptyMessage(19141010);
                        this.hasRequestForSend = false;
                        this.hasRequestSending = true;
                        break;
                    }
                    this.hasRequestSending = false;
                }
            }
        }
    };

    public RealTimeRequestController(AnalyticsRequestController.AnalyticsRequestDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public void prepareRequest() {
        if (AVOSCloud.isDebugLogEnabled() && AnalyticsImpl.enableDebugLog) {
            LogUtil.avlog.d((String)"sent real time analytics request");
        }
    }

    @Override
    public void requestToSend(String currentSessionId) {
        this.reportRequestDispatcher.sendMessage(this.makeMessage());
    }

    public Message makeMessage() {
        Message msg = new Message();
        msg.what = 19141010;
        return msg;
    }

    @Override
    public boolean requestValidate(Message msg) {
        return super.requestValidate(msg) && msg.what == 19141010;
    }

    @Override
    public void onRequestDone() {
        this.reportRequestDispatcher.sendEmptyMessage(20141010);
    }

    @Override
    public void quit() {
    }
}

