/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Message;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AnalyticsImpl;
import com.avos.avoscloud.AnalyticsRequestController;
import com.avos.avoscloud.AnalyticsSession;
import com.avos.avoscloud.IntervalRequestController;
import com.avos.avoscloud.LogUtil;
import java.util.concurrent.atomic.AtomicInteger;

class BatchRequestController
extends IntervalRequestController {
    private final AtomicInteger messageCount = new AtomicInteger(0);
    private static int messageCountThreshold = 60;

    BatchRequestController(String sessionId, AnalyticsRequestController.AnalyticsRequestDispatcher dispatcher, long defaultInterval) {
        super(sessionId, dispatcher, defaultInterval);
    }

    public int getMessageCount() {
        return this.messageCount.get();
    }

    public int incMessageCount() {
        return this.messageCount.incrementAndGet();
    }

    protected void resetMessageCount() {
        this.resetMessageCount(0);
    }

    protected void resetMessageCount(int i) {
        this.messageCount.set(i);
    }

    @Override
    public void prepareRequest() {
        if (AVOSCloud.isDebugLogEnabled() && AnalyticsImpl.enableDebugLog) {
            LogUtil.avlog.d((String)"send stats batch request");
        }
    }

    @Override
    public void requestToSend(String sessionId) {
        int count = this.incMessageCount();
        Message message = new Message();
        message.obj = sessionId;
        message.what = count;
        this.asyncHandler.sendMessage(message);
    }

    @Override
    public boolean requestValidate(Message msg) {
        return super.requestValidate(msg) || msg.what >= messageCountThreshold;
    }

    @Override
    public void appraisalSession(AnalyticsSession session) {
        if (session == null) {
            this.resetMessageCount();
        } else {
            this.resetMessageCount(session.getMessageCount());
        }
    }
}

