/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.avos.avoscloud.AVDuration;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AnalyticsActivity;
import com.avos.avoscloud.AnalyticsEvent;
import com.avos.avoscloud.AnalyticsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class AnalyticsSession
implements Parcelable {
    private List<AnalyticsActivity> activities;
    private List<AnalyticsEvent> events;
    private String sessionId = "";
    private AVDuration duration = new AVDuration();
    private static final String sessionIdTag = "sessionId";
    private static final String TAG = AnalyticsSession.class.getSimpleName();
    public static final Parcelable.Creator<AnalyticsSession> CREATOR = new Parcelable.Creator<AnalyticsSession>(){

        public AnalyticsSession createFromParcel(Parcel parcel) {
            return new AnalyticsSession(parcel);
        }

        public AnalyticsSession[] newArray(int i) {
            return new AnalyticsSession[i];
        }
    };

    public AnalyticsSession() {
        this.activities = new ArrayList<AnalyticsActivity>();
        this.events = new ArrayList<AnalyticsEvent>();
    }

    public synchronized void beginSession() {
        this.sessionId = AnalyticsUtils.uniqueId();
        this.duration.start();
    }

    public synchronized void endSession() {
        if (AVUtils.isBlankString((String)this.sessionId)) {
            return;
        }
        for (AnalyticsActivity a : this.getActivities()) {
            if (a.isStopped()) continue;
            a.stop();
        }
        for (AnalyticsEvent e : this.getEvents()) {
            if (e.getDuration().isStopped()) continue;
            e.stop();
        }
        this.duration.stop();
    }

    public boolean isSessionFinished() {
        return this.duration.isStopped();
    }

    public synchronized void pauseSession() {
        this.duration.pause();
    }

    public long getSessionStart() {
        return this.duration.getCreateTimeStamp();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionDuration(long ms) {
        this.duration.setDuration(ms);
    }

    private AnalyticsActivity activityByName(String name, boolean create) {
        for (AnalyticsActivity activity : this.activities) {
            if (!activity.getActivityName().equalsIgnoreCase(name) || activity.isStopped()) continue;
            return activity;
        }
        AnalyticsActivity activity = null;
        if (create) {
            activity = new AnalyticsActivity(name);
            this.activities.add(activity);
        }
        return activity;
    }

    private AnalyticsEvent eventByName(String name, String label, String key, boolean create) {
        for (AnalyticsEvent event : this.events) {
            if (!event.isMatch(name, label, key)) continue;
            return event;
        }
        AnalyticsEvent event = null;
        if (create) {
            event = new AnalyticsEvent(name);
            event.setLabel(label);
            event.setPrimaryKey(key);
            this.events.add(event);
        }
        return event;
    }

    public synchronized void addActivity(String name, long ms) {
        AnalyticsActivity activity = this.activityByName(name, true);
        activity.setDurationValue(ms);
    }

    public synchronized void beginActivity(String name) {
        AnalyticsActivity activity = this.activityByName(name, true);
        activity.start();
        activity.setSavedToServer(false);
        this.duration.resume();
    }

    public synchronized void beginFragment(String name) {
        AnalyticsActivity fragment = this.activityByName(name, true);
        fragment.setFragment(true);
        fragment.start();
        this.duration.resume();
    }

    public synchronized AnalyticsEvent beginEvent(Context context, String name, String label, String key) {
        AnalyticsEvent event = this.eventByName(name, label, key, true);
        if (!AVUtils.isBlankString((String)label)) {
            event.setLabel(label);
        }
        event.start();
        this.duration.resume();
        return event;
    }

    public synchronized void endEvent(Context context, String name, String label, String key) {
        AnalyticsEvent event = this.eventByName(name, label, key, false);
        if (event == null) {
            return;
        }
        event.stop();
    }

    public synchronized void endActivity(String name) {
        AnalyticsActivity activity = this.activityByName(name, false);
        if (activity == null) {
            Log.i((String)"", (String)"Please call begin activity before using endActivity");
            return;
        }
        activity.setSavedToServer(false);
        activity.stop();
    }

    public synchronized void endFragment(String name) {
        AnalyticsActivity fragment = this.activityByName(name, false);
        if (fragment == null) {
            Log.i((String)"", (String)"Please call begin Fragment before using endFragment");
            return;
        }
        fragment.stop();
    }

    public Map<String, Object> launchMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(sessionIdTag, this.sessionId);
        map.put("date", this.duration.getCreateTimeStamp());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Object> activitiesMap(boolean cleanUpAnalysisData) {
        LinkedList<Map<String, Object>> array = new LinkedList<Map<String, Object>>();
        long activitiesDuration = 0L;
        Iterator<AnalyticsActivity> i$ = this.activities.iterator();
        while (i$.hasNext()) {
            AnalyticsActivity a;
            AnalyticsActivity analyticsActivity = a = i$.next();
            synchronized (analyticsActivity) {
                if (a.isStopped() && !a.isSavedToServer()) {
                    array.add(a.jsonMap());
                    if (cleanUpAnalysisData) {
                        a.setSavedToServer(true);
                    }
                }
            }
            if (a.isFragment) continue;
            activitiesDuration += a.myDuration();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activities", array);
        map.put(sessionIdTag, this.sessionId);
        map.put("duration", this.getDuration().getActualDuration());
        return map;
    }

    public synchronized List<Object> eventArray(boolean cleanUpAnalysisData) {
        LinkedList<Object> array = new LinkedList<Object>();
        LinkedList<AnalyticsEvent> toDelete = new LinkedList<AnalyticsEvent>();
        for (AnalyticsEvent e : this.events) {
            if (!e.getDuration().isStopped()) continue;
            array.add(e.jsonMap());
            toDelete.add(e);
        }
        if (cleanUpAnalysisData) {
            this.events.removeAll(toDelete);
        }
        return array;
    }

    protected boolean hasNewData() {
        for (AnalyticsActivity a : this.activities) {
            if (!a.isStopped() || a.isSavedToServer()) continue;
            return true;
        }
        for (AnalyticsEvent e : this.events) {
            if (!e.getDuration().isStopped()) continue;
            return true;
        }
        return false;
    }

    protected int getMessageCount() {
        int messageCount = 0;
        for (AnalyticsActivity a : this.activities) {
            if (a.isStopped() && !a.isSavedToServer()) {
                messageCount += 2;
                continue;
            }
            if (a.isSavedToServer() || a.isStopped()) continue;
            ++messageCount;
        }
        for (AnalyticsEvent e : this.events) {
            if (e.getDuration().isStopped()) {
                messageCount += 2;
                continue;
            }
            ++messageCount;
        }
        return messageCount;
    }

    public Map<String, Object> jsonMap(Context context, Map<String, String> customInfo, boolean cleanUpAnalysisData) {
        if (this.hasNewData()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            HashMap<String, Object> events = new HashMap<String, Object>();
            events.put("launch", this.launchMap());
            events.put("terminate", this.activitiesMap(cleanUpAnalysisData));
            events.put("event", this.eventArray(cleanUpAnalysisData));
            result.put("events", events);
            Map<String, Object> devInfo = AnalyticsUtils.deviceInfo(context);
            result.put("device", devInfo);
            if (customInfo != null) {
                result.put("customInfo", customInfo);
            }
            return result;
        }
        return null;
    }

    protected Map<String, Object> firstBootMap(Context context, Map<String, String> customInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> events = new HashMap<String, Map<String, Object>>();
        events.put("launch", this.launchMap());
        events.put("terminate", this.activitiesMap(false));
        result.put("events", events);
        Map<String, Object> devInfo = AnalyticsUtils.deviceInfo(context);
        result.put("device", devInfo);
        if (customInfo != null) {
            result.put("customInfo", customInfo);
        }
        return result;
    }

    protected List<AnalyticsActivity> getActivities() {
        return this.activities;
    }

    protected void setActivities(List<AnalyticsActivity> activities) {
        this.activities = activities;
    }

    protected List<AnalyticsEvent> getEvents() {
        return this.events;
    }

    protected void setEvents(List<AnalyticsEvent> events) {
        this.events = events;
    }

    protected AVDuration getDuration() {
        return this.duration;
    }

    protected void setDuration(AVDuration duration) {
        this.duration = duration;
    }

    protected void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int i) {
        out.writeParcelableArray((Parcelable[])this.activities.toArray(new AnalyticsActivity[0]), 1);
        out.writeParcelableArray((Parcelable[])this.events.toArray(new AnalyticsEvent[0]), 1);
        out.writeParcelable((Parcelable)this.duration, 1);
        out.writeString(this.sessionId);
    }

    public AnalyticsSession(Parcel in) {
        this();
        Parcelable[] parcelActivities = in.readParcelableArray(AnalyticsActivity.class.getClassLoader());
        Parcelable[] parcelEvents = in.readParcelableArray(AnalyticsEvent.class.getClassLoader());
        for (Parcelable activity : parcelActivities) {
            this.activities.add((AnalyticsActivity)activity);
        }
        for (Parcelable event : parcelEvents) {
            this.events.add((AnalyticsEvent)event);
        }
        this.duration = (AVDuration)in.readParcelable(AVDuration.class.getClassLoader());
        this.sessionId = in.readString();
    }
}

