/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AnalyticsImpl;
import com.avos.avoscloud.AnalyticsRequestController;
import com.avos.avoscloud.AnalyticsUtils;
import com.avos.avoscloud.BasicAnalyticsRequestDispatcher;
import com.avos.avoscloud.BatchRequestController;
import com.avos.avoscloud.BoosterRequestController;
import com.avos.avoscloud.IntervalRequestController;
import com.avos.avoscloud.ReportPolicy;

class AnalyticsRequestControllerFactory {
    AnalyticsRequestControllerFactory() {
    }

    static AnalyticsRequestController getAnalyticsRequestController(String sessionId, ReportPolicy reportPolicy, AnalyticsImpl implement) {
        BasicAnalyticsRequestDispatcher requestController = null;
        switch (reportPolicy) {
            case SEND_INTERVAL: {
                requestController = new IntervalRequestController(sessionId, implement, AnalyticsUtils.getRequestInterval());
                break;
            }
            case REALTIME: 
            case SENDWIFIONLY: {
                requestController = implement.realTimeController;
                break;
            }
            case SEND_ON_EXIT: {
                requestController = new BoosterRequestController(sessionId, implement);
                break;
            }
            default: {
                requestController = new BatchRequestController(sessionId, implement, AnalyticsUtils.getRequestInterval());
            }
        }
        return requestController;
    }
}

