/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Parcel;
import android.os.Parcelable;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.LogUtil;

class AVDuration
implements Parcelable {
    private long createTimeStamp;
    private long resumeTimeStamp;
    private long pausedTimeStamp;
    private long duration;
    private boolean stopped;
    public static final Parcelable.Creator<AVDuration> CREATOR = new Parcelable.Creator<AVDuration>(){

        public AVDuration createFromParcel(Parcel parcel) {
            return new AVDuration(parcel);
        }

        public AVDuration[] newArray(int i) {
            return new AVDuration[i];
        }
    };

    public AVDuration() {
    }

    public long getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    public long getActualDuration() {
        long tempDuration = this.duration + this.getLastTimeInterval();
        if (tempDuration < 0L) {
            if (AVOSCloud.showInternalDebugLog()) {
                LogUtil.avlog.d((String)("Negative duration " + tempDuration));
            }
            tempDuration = 0L;
        }
        return tempDuration;
    }

    public long getDuration() {
        return this.duration;
    }

    public synchronized void start() {
        this.stopped = false;
        this.resumeTimeStamp = this.createTimeStamp = AVDuration.currentTS();
        this.pausedTimeStamp = -1L;
    }

    public synchronized void stop() {
        this.sync();
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void resume() {
        if (this.stopped) {
            return;
        }
        this.sync();
        this.resumeTimeStamp = AVDuration.currentTS();
    }

    public synchronized void pause() {
        this.pausedTimeStamp = AVDuration.currentTS();
    }

    public void setDuration(long ms) {
        this.duration = ms;
    }

    public void addDuration(long ms) {
        this.duration += ms;
    }

    public void sync() {
        if (this.stopped) {
            return;
        }
        this.duration += this.getLastTimeInterval();
        this.pausedTimeStamp = -1L;
    }

    private long getLastTimeInterval() {
        long d = 0L;
        if (this.pausedTimeStamp > this.resumeTimeStamp) {
            d = this.pausedTimeStamp - this.resumeTimeStamp;
        } else if (!this.stopped) {
            d = AVDuration.currentTS() - this.resumeTimeStamp;
        }
        return d;
    }

    public static long currentTS() {
        return System.currentTimeMillis();
    }

    protected long getResumeTimeStamp() {
        return this.resumeTimeStamp;
    }

    protected void setResumeTimeStamp(long resumeTimeStamp) {
        this.resumeTimeStamp = resumeTimeStamp;
    }

    protected void setCreateTimeStamp(long createTimeStamp) {
        this.createTimeStamp = createTimeStamp;
    }

    protected void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public long getPausedTimeStamp() {
        return this.pausedTimeStamp;
    }

    public void setPausedTimeStamp(long pausedTimeStamp) {
        this.pausedTimeStamp = pausedTimeStamp;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.createTimeStamp);
        parcel.writeLong(this.resumeTimeStamp);
        parcel.writeLong(this.pausedTimeStamp);
        parcel.writeLong(this.duration);
        parcel.writeInt(this.stopped ? 1 : 0);
    }

    public AVDuration(Parcel in) {
        this.createTimeStamp = in.readLong();
        this.resumeTimeStamp = in.readLong();
        this.pausedTimeStamp = in.readLong();
        this.duration = in.readLong();
        this.stopped = in.readInt() == 1;
    }
}

