/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.CollectionAddOp;
import com.avos.avoscloud.ops.CompoundOp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AddOp
extends CollectionAddOp {
    private List<Object> values = new LinkedList<Object>();

    public AddOp() {
    }

    public AddOp(String key, AVOp.OpType type) {
        super(key, type);
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    public AddOp(String key, Object ... values) {
        super(key, AVOp.OpType.Add);
        if (values != null) {
            for (Object obj : values) {
                this.values.add(obj);
            }
        }
    }

    @Override
    public Map<String, Object> encodeOp() {
        return AVUtils.createArrayOpMap(this.key, this.type.name(), this.getParsedValues());
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        switch (other.type()) {
            case Null: {
                return this;
            }
            case Set: {
                return other;
            }
            case Add: {
                this.values.addAll(other.cast(AddOp.class).values);
                return this;
            }
            case AddUnique: 
            case Remove: 
            case AddRelation: 
            case RemoveRelation: {
                return new CompoundOp(this.key, this, other);
            }
            case Increment: {
                throw new UnsupportedOperationException("Could not increment an non-numberic value.");
            }
            case Delete: {
                return other;
            }
            case Compound: {
                other.cast(CompoundOp.class).addFirst(this);
                return other;
            }
        }
        throw new IllegalStateException("Unknow op type " + (Object)((Object)other.type()));
    }
}

