/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVMultiPartEntity;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.signature.AES;
import com.avos.avoscloud.signature.Base64Encoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class S3Uploader
extends HttpClientUploader {
    private String access;
    private String secret;
    private String objectId;
    private String url;
    private String uuid;
    private static final String bucket = "avos-cloud";
    private static final String S3BasePath = "https://s3.amazonaws.com/avos-cloud";

    S3Uploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(parseFile, saveCallback, progressCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    AVException doWork() {
        this.uuid = UUID.randomUUID().toString().toLowerCase();
        int idx = this.parseFile.getName().indexOf(".");
        if (idx > 0) {
            String postFix = this.parseFile.getName().substring(idx);
            this.uuid = this.uuid + postFix;
        }
        DefaultHttpClient httpClient = S3Uploader.getHttpClient();
        HttpResponse response = null;
        String serverResponse = null;
        try {
            byte[] bytes = this.parseFile.getData();
            final AVException[] exceptionWhenGetBucket = new AVException[1];
            PaasClient.storageInstance().getObject("s3", null, true, null, new GenericObjectCallback(){

                @Override
                public void onSuccess(String content, AVException e) {
                    exceptionWhenGetBucket[0] = S3Uploader.this.handleGetKeyResponse(content);
                }

                @Override
                public void onFailure(Throwable error, String content) {
                    exceptionWhenGetBucket[0] = AVErrorUtils.createException(error, content);
                }
            });
            if (exceptionWhenGetBucket[0] != null) {
                AVException aVException = exceptionWhenGetBucket[0];
                return aVException;
            }
            String path = "android/" + this.uuid;
            this.url = this.getS3Link(path);
            PaasClient.storageInstance().postObject("files", this.getParametersForUrulu(), true, new GenericObjectCallback(){

                @Override
                public void onSuccess(String content, AVException e) {
                    exceptionWhenGetBucket[0] = S3Uploader.this.handlePostResponse(content);
                }

                @Override
                public void onFailure(Throwable error, String content) {
                    exceptionWhenGetBucket[0] = AVErrorUtils.createException(error, content);
                }
            });
            if (exceptionWhenGetBucket[0] != null) {
                AVException e = exceptionWhenGetBucket[0];
                return e;
            }
            BasicHttpContext httpContext = new BasicHttpContext();
            this.httpPostRef.set(new HttpPost("http://avos-cloud.s3.amazonaws.com/"));
            AVMultiPartEntity multipartContent = new AVMultiPartEntity(new AVMultiPartEntity.ProgressListener(){

                @Override
                public void transferred(long num) {
                    HttpPost httpPost;
                    if (S3Uploader.this.isCancelled() && (httpPost = (HttpPost)S3Uploader.this.httpPostRef.get()) != null) {
                        httpPost.abort();
                    }
                    S3Uploader.this.publishProgress((int)((float)num / (float)S3Uploader.this.totalSize * 100.0f));
                }
            });
            Charset charset = Charset.forName("UTF-8");
            multipartContent.addPart("acl", (ContentBody)new StringBody("public-read", charset));
            multipartContent.addPart("key", (ContentBody)new StringBody(path, charset));
            multipartContent.addPart("file", (ContentBody)new ByteArrayBody(bytes, this.uuid));
            this.totalSize = multipartContent.getContentLength();
            ((HttpPost)this.httpPostRef.get()).setEntity((HttpEntity)multipartContent);
            String contentType = multipartContent.getContentType().getValue();
            String dateString = this.RFC822FormatStringFromDate(new Date());
            ((HttpPost)this.httpPostRef.get()).addHeader("Authorization", this.authorization("POST", contentType, dateString));
            ((HttpPost)this.httpPostRef.get()).addHeader("Date", dateString);
            response = httpClient.execute((HttpUriRequest)this.httpPostRef.get(), (HttpContext)httpContext);
            if (!this.isCancelled()) {
                if (response.getStatusLine().getStatusCode() != 204) {
                    serverResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                    LogUtil.avlog.e(serverResponse);
                    AVException aVException = AVErrorUtils.createException(-1, "upload file failure");
                    return aVException;
                }
                this.parseFile.handleUploadedResponse(this.objectId, this.objectId, this.url);
            }
        }
        catch (Exception e) {
            if (this.httpPostRef.get() != null) {
                ((HttpPost)this.httpPostRef.get()).abort();
            }
            LogUtil.log.e(e.toString());
            AVException aVException = new AVException(e.getCause());
            return aVException;
        }
        finally {
            if (serverResponse == null && response != null && response.getEntity() != null) {
                try {
                    AVPersistenceUtils.closeQuietly(response.getEntity().getContent());
                }
                catch (Exception e) {}
            }
        }
        this.closeExpiredConnections();
        return null;
    }

    private AVException handleGetKeyResponse(String responseStr) {
        try {
            JSONObject jsonObject = new JSONObject(responseStr);
            AES aes = new AES();
            this.access = aes.decrypt(jsonObject.getString("access_key"));
            this.secret = aes.decrypt(jsonObject.getString("access_token"));
        }
        catch (Exception e) {
            return new AVException(e);
        }
        return null;
    }

    private AVException handlePostResponse(String responseStr) {
        try {
            JSONObject jsonObject = new JSONObject(responseStr);
            this.objectId = jsonObject.getString("objectId");
        }
        catch (JSONException e) {
            return new AVException(e);
        }
        return null;
    }

    private String getParametersForUrulu() {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("key", "android/" + this.uuid);
        parameters.put("name", this.parseFile.getName());
        parameters.put("mime_type", this.parseFile.mimeType());
        parameters.put("metaData", this.parseFile.getMetaData());
        parameters.put("__type", AVFile.className());
        parameters.put("url", this.url);
        if (this.parseFile.getACL() != null) {
            parameters.putAll(AVUtils.getParsedMap(this.parseFile.getACL().getACLMap()));
        }
        return AVUtils.restfulServerData(parameters);
    }

    private String getS3Link(String filePathOrName) {
        return "https://s3.amazonaws.com/avos-cloud/" + filePathOrName;
    }

    private String md5WithHmac(String data) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA1");
        byte[] keyBytes = this.secret.getBytes("UTF8");
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
        mac.init(signingKey);
        byte[] signBytes = mac.doFinal(data.getBytes("UTF8"));
        String signature = Base64Encoder.encode(signBytes);
        return signature;
    }

    private String authorization(String httpVerb, String contentType, String dateString) throws Exception {
        return "AWS " + this.access + ":" + this.signature(httpVerb, contentType, dateString);
    }

    private String signature(String httpVerb, String contentType, String dateString) throws Exception {
        String canonicalizedResource = "/avos-cloud/";
        String stringToSign = httpVerb + "\n" + "\n" + contentType + "\n" + dateString + "\n" + "" + canonicalizedResource;
        return this.md5WithHmac(stringToSign);
    }

    private String RFC822FormatStringFromDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }
}

