/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.util.SparseArray;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

class QiniuUploader
extends HttpClientUploader {
    private String bucket;
    private String token;
    private String key;
    private String hash;
    private String objectId;
    private String url;
    private String[] uploadFileCtx;
    private int blockCount;
    private static final String QINIU_HOST = "http://upload.qiniu.com";
    private static final String QINIU_CREATE_BLOCK_EP = "http://upload.qiniu.com/mkblk/%d";
    private static final String QINIU_BRICK_UPLOAD_EP = "http://upload.qiniu.com/bput/%s/%d";
    private static final String QINIU_MKFILE_EP = "http://upload.qiniu.com/mkfile/%d/key/%s";
    private static final int WIFI_CHUNK_SIZE = 262144;
    private static final int BLOCK_SIZE = 0x400000;
    private static final int NONWIFI_CHUNK_SIZE = 65536;
    private static final int DEFAULT_RETRY_TIMES = 6;
    static final int PROGRESS_GET_TOKEN = 10;
    static final int PROGRESS_UPLOAD_FILE = 90;
    private static final int PROGRESS_COMPLETE = 100;
    private ProgressCalculator progressCalculator;
    int uploadChunkSize = 262144;
    static final ExecutorService fileUploadExecutor = Executors.newFixedThreadPool(10);

    QiniuUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(parseFile, saveCallback, progressCallback);
    }

    @Override
    AVException doWork() {
        try {
            this.parseFileKey();
            boolean isWifi = AVUtils.isWifi(AVOSCloud.applicationContext);
            if (!isWifi) {
                this.uploadChunkSize = 65536;
            }
            if (AVOSCloud.isDebugLogEnabled()) {
                LogUtil.avlog.d("uploading with chunk size:" + this.uploadChunkSize);
            }
            byte[] bytes = this.parseFile.getData();
            return this.uploadWithBlocks();
        }
        catch (AVException e) {
            return e;
        }
    }

    private void parseFileKey() {
        this.key = AVUtils.getRandomString(40);
        int idx = 0;
        if (this.parseFile.getName() != null) {
            idx = this.parseFile.getName().lastIndexOf(".");
        }
        if (idx > 0) {
            String postFix = this.parseFile.getName().substring(idx);
            this.key = this.key + postFix;
        }
    }

    private HttpResponse executeRequest(HttpPost request) throws Exception {
        if (this.token != null) {
            request.setHeader("Authorization", "UpToken " + this.token);
        }
        return QiniuUploader.getHttpClient().execute((HttpUriRequest)request);
    }

    private AVException uploadWithBlocks() {
        try {
            byte[] bytes = this.parseFile.getData();
            AVException getBucketException = this.fetchUploadBucket();
            if (getBucketException != null) {
                return getBucketException;
            }
            this.publishProgress(10);
            this.blockCount = bytes.length / 0x400000 + (bytes.length % 0x400000 > 0 ? 1 : 0);
            this.uploadFileCtx = new String[this.blockCount];
            Object respBlockData = null;
            CountDownLatch latch = new CountDownLatch(this.blockCount);
            this.progressCalculator = new ProgressCalculator(this.blockCount, new FileUploadProgressCallback(){

                @Override
                public void onProgress(int progress) {
                    QiniuUploader.this.publishProgress(progress);
                }
            });
            Future[] tasks = new Future[this.blockCount];
            for (int blockOffset = 0; blockOffset < this.blockCount; ++blockOffset) {
                tasks[blockOffset] = fileUploadExecutor.submit(new FileBlockUploadTask(bytes, blockOffset, latch, this.uploadChunkSize, this.progressCalculator, this.uploadFileCtx, this));
            }
            latch.await();
            if (AVExceptionHolder.exists()) {
                for (Future task : tasks) {
                    if (task.isDone()) continue;
                    task.cancel(true);
                }
                throw AVExceptionHolder.remove();
            }
            QiniuMKFileResponseData mkfileResp = this.makeFile(bytes.length, this.key, 6);
            if (!this.isCancelled()) {
                if (mkfileResp == null || !mkfileResp.key.equals(this.key)) {
                    this.destroyFileObject();
                    return AVErrorUtils.createException(-1, "upload file failure");
                }
                this.parseFile.handleUploadedResponse(this.objectId, this.objectId, this.url);
                this.publishProgress(100);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.destroyFileObject();
            return new AVException(e);
        }
        this.closeExpiredConnections();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QiniuMKFileResponseData makeFile(int dataSize, String key, int retry) throws Exception {
        try {
            String endPoint = String.format(QINIU_MKFILE_EP, dataSize, AVUtils.Base64Encode(key));
            LinkedList<String> list = new LinkedList<String>();
            Collections.addAll(list, this.uploadFileCtx);
            String joinedFileCtx = AVUtils.joinCollection(list, ",");
            HttpPost putRequest = new HttpPost(endPoint);
            StringEntity entity = new StringEntity(joinedFileCtx);
            putRequest.setEntity((HttpEntity)entity);
            HttpResponse response = this.executeRequest(putRequest);
            QiniuMKFileResponseData qiniuMKFileResponseData = QiniuUploader.parseQiniuResponse(response, QiniuMKFileResponseData.class);
            return qiniuMKFileResponseData;
        }
        catch (Exception e) {
            if (retry-- > 0) {
                QiniuMKFileResponseData qiniuMKFileResponseData = this.makeFile(dataSize, key, retry);
                return qiniuMKFileResponseData;
            }
            LogUtil.log.e("Exception during file upload", e);
        }
        finally {
            this.closeExpiredConnections();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T parseQiniuResponse(HttpResponse resp, Class<T> clazz) throws Exception {
        String responseData;
        String xl;
        String phrase;
        int code;
        block17: {
            Object object;
            code = resp.getStatusLine().getStatusCode();
            phrase = resp.getStatusLine().getReasonPhrase();
            Header h = resp.getFirstHeader("X-Log");
            String string = xl = h == null ? "" : h.getValue();
            if (code == 401) {
                throw new Exception("unauthorized to create Qiniu Block");
            }
            responseData = EntityUtils.toString((HttpEntity)resp.getEntity());
            try {
                Object data;
                if (code / 100 != 2) break block17;
                object = data = JSON.parseObject((String)responseData, clazz);
            }
            catch (Exception e) {
                break block17;
            }
            finally {
                if (responseData == null && resp != null && resp.getEntity() != null) {
                    try {
                        AVPersistenceUtils.closeQuietly(resp.getEntity().getContent());
                    }
                    catch (Exception e) {}
                }
            }
            return (T)object;
        }
        if (responseData.length() > 0) {
            throw new Exception(code + ":" + responseData);
        }
        if (xl.length() > 0) {
            throw new Exception(xl);
        }
        throw new Exception(phrase);
    }

    private void destroyFileObject() {
        if (!AVUtils.isBlankString(this.objectId)) {
            try {
                AVObject fileObject = AVObject.createWithoutData("_File", this.objectId);
                fileObject.deleteInBackground(new DeleteCallback(){

                    @Override
                    public void done(AVException e) {
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private AVException handleGetBucketResponse(String responseStr, AVException exception) {
        if (exception != null) {
            return exception;
        }
        try {
            JSONObject jsonObject = new JSONObject(responseStr);
            this.bucket = jsonObject.getString("bucket");
            this.objectId = jsonObject.getString("objectId");
            this.token = jsonObject.getString("token");
            if (AVUtils.isBlankString(this.token)) {
                return new AVException(-1, "No token return for qiniu upload");
            }
            this.url = jsonObject.getString("url");
        }
        catch (JSONException e) {
            return new AVException(e);
        }
        return null;
    }

    private String getGetBucketParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("key", this.key);
        parameters.put("name", this.parseFile.getName());
        parameters.put("mime_type", this.parseFile.mimeType());
        parameters.put("metaData", this.parseFile.getMetaData());
        parameters.put("__type", AVFile.className());
        if (this.parseFile.getACL() != null) {
            parameters.putAll(AVUtils.getParsedMap(this.parseFile.getACL().getACLMap()));
        }
        return AVUtils.restfulServerData(parameters);
    }

    protected String getUploadPath() {
        return "qiniu";
    }

    protected AVException fetchUploadBucket() {
        final AVException[] exceptionWhenGetBucket = new AVException[1];
        PaasClient.storageInstance().postObject(this.getUploadPath(), this.getGetBucketParameters(), true, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                exceptionWhenGetBucket[0] = QiniuUploader.this.handleGetBucketResponse(content, e);
            }

            @Override
            public void onFailure(Throwable error, String content) {
                exceptionWhenGetBucket[0] = AVErrorUtils.createException(error, content);
            }
        });
        if (exceptionWhenGetBucket[0] != null) {
            this.destroyFileObject();
            return exceptionWhenGetBucket[0];
        }
        return null;
    }

    static interface FileUploadProgressCallback {
        public void onProgress(int var1);
    }

    private static class ProgressCalculator {
        SparseArray<Integer> blockProgress = new SparseArray();
        FileUploadProgressCallback callback;
        int fileBlockCount = 0;

        public ProgressCalculator(int blockCount, FileUploadProgressCallback callback) {
            this.callback = callback;
            this.fileBlockCount = blockCount;
        }

        public synchronized void publishProgress(int offset, int progress) {
            this.blockProgress.put(offset, (Object)progress);
            if (this.callback != null) {
                int progressSum = 0;
                for (int index = 0; index < this.blockProgress.size(); ++index) {
                    progressSum += ((Integer)this.blockProgress.valueAt(index)).intValue();
                }
                this.callback.onProgress(10 + 80 * progressSum / (100 * this.fileBlockCount));
            }
        }
    }

    private static class FileBlockUploadTask
    implements Runnable {
        private byte[] bytes;
        private int blockOffset;
        CountDownLatch latch;
        final int uploadChunkSize;
        ProgressCalculator progressCalculator;
        String[] uploadFileCtx;
        QiniuUploader parent;

        public FileBlockUploadTask(byte[] bytes, int blockOffset, CountDownLatch latch, int uploadChunkSize, ProgressCalculator progressCalculator, String[] uploadFileCtx, QiniuUploader parent) {
            this.bytes = bytes;
            this.blockOffset = blockOffset;
            this.latch = latch;
            this.uploadChunkSize = uploadChunkSize;
            this.progressCalculator = progressCalculator;
            this.uploadFileCtx = uploadFileCtx;
            this.parent = parent;
        }

        @Override
        public void run() {
            int currentBlockSize = this.getCurrentBlockSize(this.bytes, this.blockOffset);
            QiniuBlockResponseData respBlockData = this.createBlockInQiniu(this.blockOffset, currentBlockSize, 6, this.bytes);
            if (respBlockData != null) {
                if ((respBlockData = this.putFileBlocksToQiniu(this.blockOffset, this.bytes, respBlockData, 6)) != null) {
                    this.uploadFileCtx[this.blockOffset] = respBlockData.ctx;
                    this.progressCalculator.publishProgress(this.blockOffset, 100);
                } else {
                    AVExceptionHolder.add(new AVException(-1, "Upload File failure"));
                    for (long count = this.latch.getCount(); count > 0L; --count) {
                        this.latch.countDown();
                    }
                }
                this.latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private QiniuBlockResponseData createBlockInQiniu(final int blockOffset, int blockSize, int retry, final byte[] data) {
            try {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.d("try to mkblk");
                }
                String endPoint = String.format(QiniuUploader.QINIU_CREATE_BLOCK_EP, blockSize);
                HttpPost createBlockRequest = new HttpPost(endPoint);
                final int nextChunkSize = this.getNextChunkSize(blockOffset, data);
                AbstractHttpEntity entity = new AbstractHttpEntity(){

                    public void writeTo(OutputStream outstream) throws IOException {
                        byte[] ret = new byte[nextChunkSize];
                        System.arraycopy(data, blockOffset * 0x400000, ret, 0, nextChunkSize);
                        outstream.write(ret);
                    }

                    public boolean isStreaming() {
                        return false;
                    }

                    public boolean isRepeatable() {
                        return false;
                    }

                    public long getContentLength() {
                        return nextChunkSize;
                    }

                    public InputStream getContent() throws IOException, IllegalStateException {
                        return null;
                    }
                };
                createBlockRequest.setEntity((HttpEntity)entity);
                HttpResponse createBlockResp = this.parent.executeRequest(createBlockRequest);
                QiniuBlockResponseData qiniuBlockResponseData = (QiniuBlockResponseData)QiniuUploader.parseQiniuResponse(createBlockResp, QiniuBlockResponseData.class);
                return qiniuBlockResponseData;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (retry-- > 0) {
                    QiniuBlockResponseData qiniuBlockResponseData = this.createBlockInQiniu(blockOffset, blockSize, retry, data);
                    return qiniuBlockResponseData;
                }
                LogUtil.log.e("Exception during file upload", e);
            }
            finally {
                this.parent.closeExpiredConnections();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private QiniuBlockResponseData putFileBlocksToQiniu(final int blockOffset, final byte[] data, QiniuBlockResponseData lastChunk, int retry) {
            int currentBlockLength = this.getCurrentBlockSize(data, blockOffset);
            this.progressCalculator.publishProgress(blockOffset, 100 * lastChunk.offset / 0x400000);
            int remainingBlockLength = currentBlockLength - lastChunk.offset;
            if (remainingBlockLength <= 0 || lastChunk.offset <= 0) return lastChunk;
            try {
                String endPoint = String.format(QiniuUploader.QINIU_BRICK_UPLOAD_EP, lastChunk.ctx, lastChunk.offset);
                HttpPost putRequest = new HttpPost(endPoint);
                putRequest.addHeader("Content-Type", "application/octet-stream");
                final QiniuBlockResponseData chunkData = lastChunk;
                final int nextChunkSize = remainingBlockLength > this.uploadChunkSize ? this.uploadChunkSize : remainingBlockLength;
                AbstractHttpEntity entity = new AbstractHttpEntity(){

                    public void writeTo(OutputStream outstream) throws IOException {
                        byte[] ret = new byte[nextChunkSize];
                        System.arraycopy(data, blockOffset * 0x400000 + chunkData.offset, ret, 0, nextChunkSize);
                        outstream.write(ret);
                    }

                    public boolean isStreaming() {
                        return false;
                    }

                    public boolean isRepeatable() {
                        return false;
                    }

                    public long getContentLength() {
                        return nextChunkSize;
                    }

                    public InputStream getContent() throws IOException, IllegalStateException {
                        return null;
                    }
                };
                putRequest.setEntity((HttpEntity)entity);
                HttpResponse response = this.parent.executeRequest(putRequest);
                QiniuBlockResponseData respData = (QiniuBlockResponseData)QiniuUploader.parseQiniuResponse(response, QiniuBlockResponseData.class);
                if (respData == null) return null;
                if (respData.offset < currentBlockLength) {
                    QiniuBlockResponseData qiniuBlockResponseData = this.putFileBlocksToQiniu(blockOffset, data, respData, 6);
                    return qiniuBlockResponseData;
                }
                QiniuBlockResponseData qiniuBlockResponseData = respData;
                return qiniuBlockResponseData;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (retry-- > 0) {
                    QiniuBlockResponseData qiniuBlockResponseData = this.putFileBlocksToQiniu(blockOffset, data, lastChunk, retry);
                    return qiniuBlockResponseData;
                }
                LogUtil.log.e("Exception during file upload", e);
                return null;
            }
            finally {
                this.parent.closeExpiredConnections();
            }
        }

        private int getCurrentBlockSize(byte[] bytes, int blockOffset) {
            return bytes.length - blockOffset * 0x400000 > 0x400000 ? 0x400000 : bytes.length - blockOffset * 0x400000;
        }

        private int getNextChunkSize(int blockOffset, byte[] data) {
            return data.length - blockOffset * 0x400000 > this.uploadChunkSize ? this.uploadChunkSize : data.length - blockOffset * 0x400000;
        }
    }

    private static class QiniuMKFileResponseData {
        public String key;
        public String hash;

        private QiniuMKFileResponseData() {
        }
    }

    private static class QiniuBlockResponseData {
        public String ctx;
        public long crc32;
        public int offset;
        public String host;
        public String checksum;

        private QiniuBlockResponseData() {
        }
    }
}

