/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Looper;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ArchiveRequestTaskController;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RequestStatisticsUtil;
import com.loopj.android.http.AsyncHttpResponseHandler;
import org.apache.http.Header;

public class PostHttpResponseHandler
extends AsyncHttpResponseHandler {
    private GenericObjectCallback callback;
    private long requestStartTime = 0L;

    PostHttpResponseHandler(GenericObjectCallback cb) {
        super(Looper.getMainLooper());
        this.callback = cb;
    }

    void setCallback(GenericObjectCallback cb) {
        this.callback = cb;
    }

    GenericObjectCallback getCallback() {
        return this.callback;
    }

    public void onStart() {
        super.onStart();
        this.requestStartTime = System.currentTimeMillis();
    }

    public void onSuccess(int statusCode, Header[] headers, byte[] body) {
        String contentType;
        long timeInterval = System.currentTimeMillis() - this.requestStartTime;
        RequestStatisticsUtil.getInstance().recordRequestTime(statusCode, false, timeInterval);
        String content = AVUtils.stringFromBytes(body);
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d(content);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = PaasClient.extractContentType(headers), this.getCallback())) {
            return;
        }
        int code = AVErrorUtils.errorCode(content);
        if (code > 0) {
            if (this.getCallback() != null) {
                this.getCallback().onFailure(AVErrorUtils.createException(code, content), content);
            }
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onSuccess(content, null);
        }
        ArchiveRequestTaskController.schedule();
    }

    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        String contentType;
        long timeInterval = System.currentTimeMillis() - this.requestStartTime;
        RequestStatisticsUtil.getInstance().recordRequestTime(statusCode, statusCode == 0, timeInterval);
        String content = AVUtils.stringFromBytes(responseBody);
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.e(content + "\nerror:" + error);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = PaasClient.extractContentType(headers), this.getCallback())) {
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onFailure(statusCode, error, content);
        }
    }
}

