/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVObjectReferenceCount;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DNSRetryCallback;
import com.avos.avoscloud.DataFetchCallbackWithFailureRetry;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PostHttpResponseHandler;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SyncHttpClient;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;

public class PaasClient {
    private static final CookieStore COOKIE_STORE = new ForgotCookieStore();
    private static String baseUrl;
    private final String apiVersion;
    private static String applicationIdField;
    private static String apiKeyField;
    protected static String sessionTokenField;
    private static boolean isUrulu;
    private static boolean isCN;
    private boolean isProduction = true;
    private static final String defaultEncoding = "UTF-8";
    private static final String defaultContentType = "application/json";
    public static final String DEFAULT_FAIL_STRING = "request failed!!!";
    public static final String sdkVersion = "v3.7.5";
    private static final String userAgent = "AVOS Cloud android-v3.7.5 SDK";
    private AVUser currentUser = null;
    private AVACL defaultACL;
    private SyncHttpClient syncHttpClient;
    private AsyncHttpClient asyncHttpClient;
    private static boolean lastModifyEnabled;
    static Map<String, String> serviceHostMap;
    static HashMap<String, PaasClient> serviceClientMap;
    static Map<String, AVObjectReferenceCount> internalObjectsForEventuallySave;
    private static Map<String, String> lastModify;
    private static Comparator<File> fileModifiedDateComparator;

    void setProduction(boolean production) {
        this.isProduction = production;
    }

    public static boolean isAVOSCloud() {
        return isUrulu;
    }

    protected static PaasClient sharedInstance(AVOSServices service) {
        String host = AVUtils.isBlankString(serviceHostMap.get(service.toString())) ? serviceHostMap.get(AVOSServices.STORAGE_SERVICE.toString()) : serviceHostMap.get(service.toString());
        PaasClient instance = serviceClientMap.get(host);
        if (instance == null) {
            instance = new PaasClient();
            instance.setBaseUrl(host);
            serviceClientMap.put(host, instance);
        }
        return instance;
    }

    public static PaasClient storageInstance() {
        return PaasClient.sharedInstance(AVOSServices.STORAGE_SERVICE);
    }

    public static PaasClient cloudInstance() {
        return PaasClient.sharedInstance(AVOSServices.FUNCTION_SERVICE);
    }

    public static PaasClient statistisInstance() {
        return PaasClient.sharedInstance(AVOSServices.STATISTICS_SERVICE);
    }

    AVACL getDefaultACL() {
        return this.defaultACL;
    }

    void setDefaultACL(AVACL acl) {
        this.defaultACL = acl;
    }

    AVUser getCurrentUser() {
        return this.currentUser;
    }

    public Map<String, String> userHeaderMap() {
        AVUser user = AVUser.getCurrentUser();
        if (user != null) {
            return user.headerMap();
        }
        return null;
    }

    void setCurrentUser(AVUser user) {
        this.currentUser = user;
    }

    private PaasClient() {
        this.apiVersion = "1.1";
        if (isUrulu) {
            this.useUruluServer();
        }
    }

    private String signRequest() {
        StringBuilder builder = new StringBuilder();
        long ts = AVUtils.getCurrentTimestamp();
        StringBuilder result = new StringBuilder();
        result.append(AVUtils.md5(builder.append(ts).append(AVOSCloud.clientKey).toString()).toLowerCase());
        return result.append(",").append(ts).toString();
    }

    private void updateHeaders(AsyncHttpClient client) {
        client.addHeader("X-LC-Prod", this.isProduction ? "1" : "0");
        AVUser currAVUser = AVUser.getCurrentUser();
        client.addHeader(sessionTokenField, currAVUser != null && currAVUser.getSessionToken() != null ? currAVUser.getSessionToken() : "");
        client.addHeader(applicationIdField, AVOSCloud.applicationId);
        client.addHeader("Accept", defaultContentType);
        client.addHeader("Content-Type", defaultContentType);
        client.setUserAgent(userAgent);
        client.addHeader("X-LC-Sign", this.signRequest());
    }

    private void configHttpClient(AsyncHttpClient client) {
        client.getHttpClient().getParams().setBooleanParameter("http.tcp.nodelay", true);
        client.setCookieStore(COOKIE_STORE);
        client.setThreadPool(Executors.newFixedThreadPool(AVOSCloud.getThreadPoolSize()));
    }

    private void configTimeout(AsyncHttpClient client) {
        client.setTimeout(AVOSCloud.getNetworkTimeout());
    }

    public synchronized AsyncHttpClient clientInstance(boolean sync) {
        if (sync) {
            if (this.syncHttpClient == null) {
                this.syncHttpClient = new SyncHttpClient(){

                    public String onRequestFailed(Throwable throwable, String s) {
                        return s != null ? s : throwable.getMessage();
                    }
                };
                this.configHttpClient((AsyncHttpClient)this.syncHttpClient);
            }
            this.updateHeaders((AsyncHttpClient)this.syncHttpClient);
            this.configTimeout((AsyncHttpClient)this.syncHttpClient);
            return this.syncHttpClient;
        }
        if (this.asyncHttpClient == null) {
            this.asyncHttpClient = new AsyncHttpClient();
            this.configHttpClient(this.asyncHttpClient);
        }
        this.updateHeaders(this.asyncHttpClient);
        this.configTimeout(this.asyncHttpClient);
        return this.asyncHttpClient;
    }

    public void useUruluServer() {
        if (isCN) {
            PaasClient.useAVCloudCN();
        } else {
            this.useAVCloudUS();
        }
    }

    public void useAVCloudUS() {
        isUrulu = true;
        isCN = false;
        baseUrl = "https://us-api.leancloud.cn";
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), baseUrl);
        applicationIdField = "X-LC-Id";
        apiKeyField = "X-LC-Key";
        sessionTokenField = "X-LC-Session";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeS3);
        PaasClient.switchPushRouter("useAVOSCloudUS");
    }

    private static void switchPushRouter(String routerServer) {
        try {
            Class<?> avPushRouterClass = Class.forName("com.avos.avospush.push.AVPushRouter");
            Method switchMethod = avPushRouterClass.getMethod(routerServer, new Class[0]);
            switchMethod.invoke(avPushRouterClass, new Object[0]);
        }
        catch (Exception e) {
            LogUtil.avlog.i("avpushRouter server didn't switched");
        }
    }

    public static void useAVCloudCN() {
        isUrulu = true;
        baseUrl = "https://api.leancloud.cn";
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), baseUrl);
        applicationIdField = "X-LC-Id";
        apiKeyField = "X-LC-Key";
        sessionTokenField = "X-LC-Session";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeQiniu);
        PaasClient.switchPushRouter("useAVOSCloudCN");
    }

    public static void useLocalStg() {
        isUrulu = true;
        baseUrl = "https://cn-stg1.avoscloud.com";
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), baseUrl);
        applicationIdField = "X-LC-Id";
        apiKeyField = "X-LC-Key";
        sessionTokenField = "X-LC-Session";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeQiniu);
    }

    public String buildUrl(String path) {
        return String.format("%s/%s/%s", baseUrl, this.apiVersion, path);
    }

    private String batchUrl() {
        return String.format("%s/%s/batch", baseUrl, this.apiVersion);
    }

    private String batchSaveRelativeUrl() {
        return "batch/save";
    }

    private AsyncHttpResponseHandler createGetHandler(GenericObjectCallback callback, AVQuery.CachePolicy policy, String absoluteURLString) {
        GetHttpResponseHandler handler = new GetHttpResponseHandler(callback, policy, absoluteURLString);
        return handler;
    }

    private AsyncHttpResponseHandler createPostHandler(GenericObjectCallback callback) {
        PostHttpResponseHandler handler = new PostHttpResponseHandler(callback);
        return handler;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setBaseUrl(String url) {
        baseUrl = url;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    protected static void setServiceHost(AVOSServices service, String host) {
        serviceHostMap.put(service.toString(), host);
    }

    public String getObject(final String relativePath, final RequestParams parameters, final boolean sync, final Map<String, String> header, final GenericObjectCallback callback, final AVQuery.CachePolicy policy, final long maxAgeInMilliseconds) {
        final String absolutURLString = this.generateQueryPath(relativePath, parameters);
        final String lastModifyTime = PaasClient.getLastModify(absolutURLString);
        switch (policy) {
            default: {
                this.getObject(relativePath, parameters, sync, header, callback, policy);
                break;
            }
            case CACHE_ONLY: {
                AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, callback);
                break;
            }
            case NETWORK_ONLY: {
                this.getObject(relativePath, parameters, sync, header, callback, policy);
                break;
            }
            case CACHE_ELSE_NETWORK: {
                AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                this.getObject(relativePath, parameters, sync, header, new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        AVCacheManager cacheManager = AVCacheManager.sharedInstance();
                        if (cacheManager.hasValidCache(absolutURLString, lastModifyTime, maxAgeInMilliseconds)) {
                            cacheManager.get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, callback);
                        } else {
                            callback.onFailure(error, content);
                        }
                    }
                }, policy);
                break;
            }
            case CACHE_THEN_NETWORK: {
                AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        callback.onFailure(error, content);
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }
                });
            }
        }
        return absolutURLString;
    }

    String generateQueryPath(String relativePath, RequestParams parameters) {
        String absolutURLString = AsyncHttpClient.getUrlWithQueryString((boolean)true, (String)this.buildUrl(relativePath), (RequestParams)parameters);
        return absolutURLString;
    }

    public void getObject(String relativePath, RequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy) {
        this.getObject(relativePath, parameters, sync, inputHeader, callback, policy, !policy.equals((Object)AVQuery.CachePolicy.CACHE_ONLY) && PaasClient.isLastModifyEnabled());
    }

    public void getObject(String relativePath, RequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy, boolean fetchRetry) {
        this.getObject(relativePath, parameters, sync, inputHeader, fetchRetry ? new DataFetchCallbackWithFailureRetry(relativePath, parameters, sync, null, callback, policy) : callback, policy, fetchRetry, true);
    }

    protected void getObject(final String relativePath, final RequestParams parameters, final boolean sync, final Map<String, String> inputHeader, GenericObjectCallback callback, final AVQuery.CachePolicy policy, final boolean fetchRetry, boolean dnsRetry) {
        Map<String, String> myHeader = inputHeader;
        if (inputHeader == null) {
            myHeader = new HashMap<String, String>();
        }
        this.updateHeaderForPath(relativePath, parameters, myHeader);
        String url = this.buildUrl(relativePath);
        GenericObjectCallback retryCallback = dnsRetry ? new DNSRetryCallback(this.getBaseUrl(), callback){

            @Override
            public boolean isRetryNeeded(int statusCode, Throwable error) {
                return AVUtils.checkDNSException(statusCode, error);
            }

            @Override
            public void executeRequest() {
                PaasClient.this.getObject(relativePath, parameters, sync, inputHeader, this.callback, policy, fetchRetry, false);
            }
        } : callback;
        AsyncHttpResponseHandler handler = this.createGetHandler(retryCallback, policy, AsyncHttpClient.getUrlWithQueryString((boolean)true, (String)url, (RequestParams)parameters));
        if (AVOSCloud.isDebugLogEnabled()) {
            this.dumpHttpGetRequest(url, parameters);
        }
        AsyncHttpClient client = this.clientInstance(sync);
        this.addHeader(client, myHeader);
        client.get(url, parameters, (ResponseHandlerInterface)handler);
    }

    public void getObject(String relativePath, RequestParams parameters, boolean sync, Map<String, String> header, GenericObjectCallback callback) {
        this.getObject(relativePath, parameters, sync, header, callback, AVQuery.CachePolicy.IGNORE_CACHE);
    }

    public void putObject(String relativePath, String object, boolean sync, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        this.putObject(relativePath, object, sync, false, header, callback, objectId, _internalId);
    }

    private void addHeader(AsyncHttpClient client, Map<String, String> header) {
        if (header == null) {
            return;
        }
        for (Map.Entry<String, String> entry : header.entrySet()) {
            client.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public void putObject(String relativePath, String object, boolean sync, boolean isEventually, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        this.putObject(relativePath, object, sync, isEventually, header, callback, objectId, _internalId, true);
    }

    private void putObject(final String relativePath, final String object, final boolean sync, final boolean isEventually, final Map<String, String> header, GenericObjectCallback callback, final String objectId, final String _internalId, boolean dnsRetry) {
        try {
            GenericObjectCallback retryCallback = dnsRetry ? new DNSRetryCallback(this.getBaseUrl(), callback){

                @Override
                public void executeRequest() {
                    PaasClient.this.putObject(relativePath, object, sync, isEventually, header, this.callback, objectId, _internalId, false);
                }
            } : callback;
            if (isEventually) {
                File archivedFile = this.archiveRequest("put", relativePath, object, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, retryCallback);
            } else {
                String url = this.buildUrl(relativePath);
                ByteArrayEntity entity = new ByteArrayEntity(object.getBytes(defaultEncoding));
                AsyncHttpResponseHandler handler = this.createPostHandler(retryCallback);
                if (AVOSCloud.isDebugLogEnabled()) {
                    this.dumpHttpPutRequest(header, url, object);
                }
                AsyncHttpClient client = this.clientInstance(sync);
                this.addHeader(client, header);
                client.put(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    private void processException(Exception e, GenericObjectCallback cb) {
        if (cb != null) {
            cb.onFailure(e, null);
        }
    }

    Map<String, Object> batchItemMap(String method, String path, Object body, Map params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("method", method);
        result.put("path", path);
        result.put("body", body);
        if (params != null) {
            result.put("params", params);
        }
        return result;
    }

    Map<String, Object> batchItemMap(String method, String path, Object body) {
        return this.batchItemMap(method, path, body, null);
    }

    @Deprecated
    List<Object> assembleBatchOpsList(List<Object> itemList, String path) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : itemList) {
            Map<String, Object> opDict = this.batchItemMap("PUT", path, object);
            list.add(opDict);
        }
        return list;
    }

    private Map<String, Object> batchRequest(List<Object> list) {
        HashMap<String, Object> requests = new HashMap<String, Object>();
        requests.put("requests", list);
        return requests;
    }

    public void postBatchObject(List<Object> parameters, boolean sync, Map<String, String> header, GenericObjectCallback callback) {
        try {
            String url = this.batchUrl();
            Map<String, Object> requests = this.batchRequest(parameters);
            String json = JSON.toJSONString(requests);
            ByteArrayEntity entity = new ByteArrayEntity(json.getBytes(defaultEncoding));
            if (AVOSCloud.isDebugLogEnabled()) {
                this.dumpHttpPostRequest(header, url, json);
            }
            AsyncHttpResponseHandler handler = this.createPostHandler(callback);
            AsyncHttpClient client = this.clientInstance(sync);
            this.addHeader(client, header);
            client.post(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postBatchSave(List list, boolean sync, boolean isEventually, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        this.postBatchSave(list, sync, isEventually, header, callback, objectId, _internalId, true);
    }

    private void postBatchSave(final List list, final boolean sync, final boolean isEventually, final Map<String, String> header, GenericObjectCallback callback, final String objectId, final String _internalId, boolean dnsRetry) {
        try {
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("requests", list);
            String paramString = AVUtils.jsonStringFromMapWithNull(params);
            GenericObjectCallback retryCallback = dnsRetry ? new DNSRetryCallback(this.getBaseUrl(), callback){

                @Override
                public void executeRequest() {
                    PaasClient.this.postBatchSave(list, sync, isEventually, header, this.callback, objectId, _internalId, false);
                }
            } : callback;
            if (isEventually) {
                File archivedFile = this.archiveRequest("post", this.batchSaveRelativeUrl(), paramString, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, retryCallback);
            } else {
                String url = this.buildUrl(this.batchSaveRelativeUrl());
                ByteArrayEntity entity = new ByteArrayEntity(paramString.getBytes(defaultEncoding));
                if (AVOSCloud.isDebugLogEnabled()) {
                    this.dumpHttpPostRequest(header, url, paramString);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(retryCallback);
                AsyncHttpClient client = this.clientInstance(sync);
                this.addHeader(client, header);
                client.post(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postObject(String relativePath, String object, boolean sync, GenericObjectCallback callback) {
        this.postObject(relativePath, object, sync, false, callback, null, null);
    }

    public void postObject(String relativePath, String object, boolean sync, boolean isEventually, GenericObjectCallback callback, String objectId, String _internalId) {
        this.postObject(relativePath, object, sync, isEventually, callback, objectId, _internalId, true);
    }

    private void postObject(final String relativePath, final String object, final boolean sync, final boolean isEventually, GenericObjectCallback callback, final String objectId, final String _internalId, boolean dnsRetry) {
        try {
            GenericObjectCallback retryCallback = dnsRetry ? new DNSRetryCallback(this.getBaseUrl(), callback){

                @Override
                public void executeRequest() {
                    PaasClient.this.postObject(relativePath, object, sync, isEventually, this.callback, objectId, _internalId, false);
                }
            } : callback;
            if (isEventually) {
                File archivedFile = this.archiveRequest("post", relativePath, object, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, retryCallback);
            } else {
                String url = this.buildUrl(relativePath);
                ByteArrayEntity entity = new ByteArrayEntity(object.getBytes(defaultEncoding));
                if (AVOSCloud.isDebugLogEnabled()) {
                    this.dumpHttpPostRequest(null, url, object);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(retryCallback);
                this.clientInstance(sync).post(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void deleteObject(String relativePath, boolean sync, GenericObjectCallback callback, String objectId, String _internalId) {
        this.deleteObject(relativePath, sync, false, callback, objectId, _internalId);
    }

    public void deleteObject(String relativePath, boolean sync, boolean isEventually, GenericObjectCallback callback, String objectId, String _internalId) {
        this.deleteObject(relativePath, sync, isEventually, callback, objectId, _internalId, true);
    }

    public void deleteObject(final String relativePath, final boolean sync, final boolean isEventually, GenericObjectCallback callback, final String objectId, final String _internalId, boolean dnsRetry) {
        try {
            GenericObjectCallback retryCallback = dnsRetry ? new DNSRetryCallback(this.getBaseUrl(), callback){

                @Override
                public void executeRequest() {
                    PaasClient.this.deleteObject(relativePath, sync, isEventually, this.callback, objectId, _internalId, false);
                }
            } : callback;
            if (isEventually) {
                File archivedFile = this.archiveRequest("delete", relativePath, null, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, retryCallback);
            } else {
                String url = this.buildUrl(relativePath);
                if (AVOSCloud.isDebugLogEnabled()) {
                    this.dumpHttpDeleteRequest(null, url, null);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(retryCallback);
                this.clientInstance(sync).delete(url, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    private File archiveRequest(String method, String relativePath, String paramString, String objectId, String _internalId) {
        File theArchivedFile = new File(AVPersistenceUtils.getCommandCacheDir(), AVUtils.getArchiveRequestFileName(objectId, _internalId, method, relativePath, paramString));
        HashMap<String, String> fileMap = new HashMap<String, String>(3);
        fileMap.put("method", method);
        fileMap.put("relativePath", relativePath);
        fileMap.put("paramString", paramString);
        fileMap.put("objectId", objectId);
        fileMap.put("_internalId", _internalId);
        AVPersistenceUtils.saveContentToFile(AVUtils.toJSON(fileMap), theArchivedFile);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.log.d(AVUtils.restfulServerData(fileMap) + "\n" + "did save to " + theArchivedFile.getAbsolutePath());
        }
        return theArchivedFile;
    }

    private void handleArchivedRequest(File archivedFile, boolean sync) {
        this.handleArchivedRequest(archivedFile, sync, null);
    }

    private void handleArchivedRequest(final File archivedFile, boolean sync, final GenericObjectCallback callback) {
        try {
            String archivedFileContent = AVPersistenceUtils.readContentFromFile(archivedFile);
            Map fileMap = null;
            fileMap = AVUtils.getFromJSON(archivedFileContent, Map.class);
            if (fileMap != null && !fileMap.isEmpty()) {
                String method = (String)fileMap.get("method");
                String relativePath = (String)fileMap.get("relativePath");
                String paramString = (String)fileMap.get("paramString");
                String objectId = (String)fileMap.get("objectId");
                String _internalId = (String)fileMap.get("_internalId");
                GenericObjectCallback newCallback = new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        if (callback != null) {
                            callback.onSuccess(content, e);
                        }
                        try {
                            Map objectMap = AVUtils.getFromJSON(content, Map.class);
                            for (String _internalId : objectMap.keySet()) {
                                if (internalObjectsForEventuallySave.get(_internalId) == null) continue;
                                internalObjectsForEventuallySave.get(_internalId).getValue().copyFromMap(objectMap);
                                PaasClient.unregisterEvtuallyObject(internalObjectsForEventuallySave.get(_internalId).getValue());
                            }
                        }
                        catch (Exception e1) {
                            LogUtil.avlog.e("parse exception during archive request" + e.getMessage());
                        }
                        archivedFile.delete();
                        AVPersistenceUtils.removeLock(archivedFile.getAbsolutePath());
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        if (callback != null) {
                            callback.onFailure(error, content);
                        }
                        AVPersistenceUtils.removeLock(archivedFile.getAbsolutePath());
                    }
                };
                if (method == null) {
                    newCallback.onFailure(new AVRuntimeException("Null method."), null);
                }
                if ("post".equalsIgnoreCase(method)) {
                    this.postObject(relativePath, paramString, sync, newCallback);
                } else if ("put".equalsIgnoreCase(method)) {
                    this.putObject(relativePath, paramString, sync, null, newCallback, objectId, _internalId);
                } else if ("delete".equalsIgnoreCase(method)) {
                    this.deleteObject(relativePath, sync, newCallback, objectId, _internalId);
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void handleAllArchivedRequest() {
        this.handleAllArchivedRequest(false);
    }

    protected void handleAllArchivedRequest(boolean sync) {
        File commandCacheDir = AVPersistenceUtils.getCommandCacheDir();
        File[] archivedRequests = commandCacheDir.listFiles();
        if (archivedRequests != null && archivedRequests.length > 0) {
            Arrays.sort(archivedRequests, fileModifiedDateComparator);
            for (File file : archivedRequests) {
                if (file.isFile()) {
                    this.handleArchivedRequest(file, sync);
                    continue;
                }
                if (!AVOSCloud.showInternalDebugLog()) continue;
                LogUtil.avlog.e(file.getAbsolutePath() + " is a dir");
            }
        }
    }

    public void dumpHttpGetRequest(String path, RequestParams parameters) {
        String string = "";
        string = parameters != null ? String.format("curl -X GET -H \"%s: %s\" -H \"%s: %s\" -G --data-urlencode '%s' %s", applicationIdField, AVOSCloud.applicationId, apiKeyField, this.getDebugClientKey(), parameters.toString(), path) : String.format("curl -X GET -H \"%s: %s\" -H \"%s: %s\"  %s", applicationIdField, AVOSCloud.applicationId, apiKeyField, this.getDebugClientKey(), path);
        LogUtil.avlog.d(string);
    }

    private String getDebugClientKey() {
        if (AVOSCloud.showInternalDebugLog()) {
            return AVOSCloud.clientKey;
        }
        return "YourAppKey";
    }

    private String headerString(Map<String, String> header) {
        String string = String.format(" -H \"%s: %s\" -H \"%s: %s\" ", applicationIdField, AVOSCloud.applicationId, apiKeyField, this.getDebugClientKey());
        StringBuilder sb = new StringBuilder(string);
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                String item = String.format(" -H \"%s: %s\" ", entry.getKey(), entry.getValue());
                sb.append(item);
            }
        }
        sb.append(" -H \"Content-Type: application/json\" ");
        return sb.toString();
    }

    public void dumpHttpPutRequest(Map<String, String> header, String path, String object) {
        String string = String.format("curl -X PUT %s  -d ' %s ' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string);
    }

    public void dumpHttpPostRequest(Map<String, String> header, String path, String object) {
        String string = String.format("curl -X POST %s  -d '%s' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string);
    }

    public void dumpHttpDeleteRequest(Map<String, String> header, String path, String object) {
        String string = String.format("curl -X DELETE %s  -d '%s' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string);
    }

    public void updateHeaderForPath(String relativePath, RequestParams parameters, Map<String, String> header) {
        if (PaasClient.isLastModifyEnabled() && null != header && !TextUtils.isEmpty((CharSequence)relativePath)) {
            String absoluteURLString = this.generateQueryPath(relativePath, parameters);
            String modify = PaasClient.getLastModify(absoluteURLString);
            boolean exist = AVCacheManager.sharedInstance().hasCache(absoluteURLString, modify);
            if (modify != null && exist) {
                header.put("If-Modified-Since", modify);
            }
        }
    }

    public static String getLastModify(String absolutURLString) {
        if (!PaasClient.isLastModifyEnabled()) {
            return null;
        }
        return lastModify.get(absolutURLString);
    }

    public static boolean isLastModifyEnabled() {
        return lastModifyEnabled;
    }

    public static void setLastModifyEnabled(boolean e) {
        lastModifyEnabled = e;
    }

    public static void clearLastModifyCache() {
        for (Map.Entry<String, String> pairs : lastModify.entrySet()) {
            AVCacheManager.sharedInstance().remove(pairs.getKey(), pairs.getValue());
        }
        lastModify.clear();
    }

    public static String lastModifyFromHeaders(Header[] headers) {
        for (Header h : headers) {
            if (!h.getName().equalsIgnoreCase("Last-Modified")) continue;
            return h.getValue();
        }
        return null;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static boolean isJSONResponse(String contentType) {
        if (!AVUtils.isBlankString(contentType)) {
            return contentType.toLowerCase().contains(defaultContentType);
        }
        return false;
    }

    protected static String extractContentType(Header[] headers) {
        if (headers != null) {
            for (Header h : headers) {
                if (!h.getName().equalsIgnoreCase("Content-Type")) continue;
                return h.getValue();
            }
        }
        return null;
    }

    public static boolean updateLastModify(String absolutURLString, String ts) {
        if (!PaasClient.isLastModifyEnabled()) {
            return false;
        }
        if (!AVUtils.isBlankString(ts)) {
            lastModify.put(absolutURLString, ts);
            return true;
        }
        return false;
    }

    public static void removeLastModifyForUrl(String absolutURLString) {
        lastModify.remove(absolutURLString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerEventuallyObject(AVObject object) {
        if (object != null) {
            AVObject aVObject = object;
            synchronized (aVObject) {
                AVObjectReferenceCount counter = internalObjectsForEventuallySave.get(object.internalId());
                if (counter != null) {
                    counter.increment();
                } else {
                    counter = new AVObjectReferenceCount(object);
                    internalObjectsForEventuallySave.put(object.internalId(), counter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterEvtuallyObject(AVObject object) {
        if (object != null) {
            AVObject aVObject = object;
            synchronized (aVObject) {
                AVObjectReferenceCount counter;
                AVObjectReferenceCount aVObjectReferenceCount = counter = internalObjectsForEventuallySave.get(object.internalId()) == null ? internalObjectsForEventuallySave.get(object.internalId()) : internalObjectsForEventuallySave.get(object.getUuid());
                if (counter != null && counter.desc() <= 0) {
                    internalObjectsForEventuallySave.remove(object.internalId());
                    internalObjectsForEventuallySave.remove(object.getUuid());
                }
            }
        }
    }

    static {
        isUrulu = true;
        isCN = true;
        lastModifyEnabled = false;
        serviceHostMap = Collections.synchronizedMap(new HashMap());
        serviceClientMap = new HashMap();
        internalObjectsForEventuallySave = Collections.synchronizedMap(new HashMap());
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), "https://api.leancloud.cn");
        lastModify = Collections.synchronizedMap(new WeakHashMap());
        fileModifiedDateComparator = new Comparator<File>(){

            @Override
            public int compare(File f, File s) {
                return (int)(f.lastModified() - s.lastModified());
            }
        };
    }

    private static final class ForgotCookieStore
    implements CookieStore {
        private ForgotCookieStore() {
        }

        public List<Cookie> getCookies() {
            return Collections.emptyList();
        }

        public boolean clearExpired(Date date) {
            return true;
        }

        public void clear() {
        }

        public void addCookie(Cookie cookie) {
        }
    }
}

