/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;

abstract class IntervalTimer {
    private final long mCountdownInterval;
    private volatile long mTriggerTimeInFuture;
    private volatile boolean mCancelled = false;
    private static final int MSG = 1;
    private static final int SKIP = -1;
    private Handler mHandler;

    public IntervalTimer(long countDownInterval) {
        this(null, countDownInterval);
    }

    public IntervalTimer(Looper looper, long countDownInterval) {
        this.mCountdownInterval = countDownInterval;
        this.mHandler = new Handler(looper == null ? Looper.getMainLooper() : looper){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                IntervalTimer intervalTimer = IntervalTimer.this;
                synchronized (intervalTimer) {
                    if (IntervalTimer.this.mCancelled) {
                        return;
                    }
                    switch (msg.what) {
                        case 1: {
                            long millisLeft = IntervalTimer.this.mTriggerTimeInFuture - SystemClock.elapsedRealtime();
                            if (millisLeft <= 0L) {
                                IntervalTimer.this.onTrigger();
                                IntervalTimer.this.mTriggerTimeInFuture = IntervalTimer.this.mTriggerTimeInFuture + IntervalTimer.this.mCountdownInterval - millisLeft;
                                this.sendMessageDelayed(this.obtainMessage(1), IntervalTimer.this.mCountdownInterval);
                                break;
                            }
                            if (millisLeft > IntervalTimer.this.mCountdownInterval) break;
                            this.sendMessageDelayed(this.obtainMessage(1), millisLeft);
                            break;
                        }
                        case -1: {
                            IntervalTimer.this.mTriggerTimeInFuture = SystemClock.elapsedRealtime() + IntervalTimer.this.mCountdownInterval;
                        }
                    }
                }
            }
        };
    }

    public synchronized void cancel() {
        this.mCancelled = true;
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(-1);
    }

    public final void skip() {
        this.mHandler.sendEmptyMessage(-1);
    }

    public abstract void onTrigger();

    protected final synchronized IntervalTimer start() {
        this.mCancelled = false;
        this.mTriggerTimeInFuture = SystemClock.elapsedRealtime() + this.mCountdownInterval;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        return this;
    }
}

