/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVNetworkHelper;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GenericRetryCallback;
import com.avos.avoscloud.LogUtil;
import java.net.URISyntaxException;

public abstract class DNSRetryCallback
extends GenericRetryCallback {
    String url;

    public DNSRetryCallback(String url, GenericObjectCallback callback) {
        super(callback);
        this.url = url;
    }

    @Override
    public boolean isRetryNeeded(int statusCode, Throwable error) {
        return AVUtils.checkDNSException(statusCode, error);
    }

    @Override
    public void retry(final Throwable error, final String content) {
        try {
            AVNetworkHelper.amendDNS(AVUtils.getHostName(this.url), new AVNetworkHelper.DNSUpdateCallback(){

                @Override
                public void done(AVException e) {
                    if (e == null) {
                        DNSRetryCallback.this.executeRequest();
                    } else {
                        if (AVOSCloud.showInternalDebugLog()) {
                            LogUtil.avlog.e(e.getMessage());
                        }
                        DNSRetryCallback.this.callback.onFailure(error, content);
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            this.callback.onFailure(error, content);
        }
    }

    public abstract void executeRequest();
}

