/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.SuppressLint;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RequestStatisticsUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@SuppressLint(value={"NewApi"})
public class ArchiveRequestTaskController {
    static ScheduledExecutorService scheduledExecutorService;
    static ScheduledFuture<?> scheduledFuture;
    private static Lock lock;
    private static final long TIME_DELAY_FOR_ARCHIVEREQUEST = 30L;
    static Runnable archiveRequestTask;

    public static synchronized void schedule() {
        boolean cancelled = true;
        if (scheduledExecutorService == null) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            cancelled = scheduledFuture.cancel(false);
        }
        if (cancelled) {
            scheduledFuture = scheduledExecutorService.schedule(archiveRequestTask, 30L, TimeUnit.SECONDS);
        }
    }

    static {
        lock = new ReentrantLock();
        archiveRequestTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AVOSCloud.showInternalDebugLog()) {
                    LogUtil.avlog.d("trying to send archive request");
                }
                if (!AVUtils.isBlankString(AVOSCloud.applicationId) && AVOSCloud.applicationContext != null) {
                    if (lock.tryLock()) {
                        try {
                            PaasClient.storageInstance().handleAllArchivedRequest(true);
                            RequestStatisticsUtil.getInstance().sendToServer();
                        }
                        catch (Exception e) {
                            LogUtil.log.e("Exception happended during processing archive requests", e);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                } else {
                    LogUtil.log.e("applicationContext is null, Please call AVOSCloud.initialize first");
                }
            }
        };
    }
}

