/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Build;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

abstract class AVUploader {
    protected final AVFile parseFile;
    protected SaveCallback saveCallback;
    protected ProgressCallback progressCallback;
    protected long totalSize;
    private volatile boolean cancelled = false;
    private volatile boolean complete = false;
    private volatile Future future;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 1L;
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    protected static final int defaultFileKeyLength = 40;

    protected AVUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        this.parseFile = parseFile;
        this.saveCallback = saveCallback;
        this.progressCallback = progressCallback;
        this.cancelled = false;
        this.complete = false;
    }

    abstract AVException doWork();

    public void execute() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AVException exception = AVUploader.this.doWork();
                if (!AVUploader.this.cancelled) {
                    AVUploader.this.complete = true;
                    AVUploader.this.onPostExecute(exception);
                } else {
                    AVUploader.this.onPostExecute(AVErrorUtils.createException(999, "Uploading file task is canceled."));
                }
            }
        };
        this.future = executor.submit(task);
    }

    protected AVException doInBackground(Void ... arg0) {
        return this.doWork();
    }

    protected void onProgressUpdate(Integer progress) {
        if (this.progressCallback != null) {
            this.progressCallback.internalDone(progress, null);
        }
    }

    protected void onPostExecute(AVException result) {
        if (this.saveCallback != null) {
            this.saveCallback.internalDone(result);
        }
    }

    protected void onCancelled() {
        LogUtil.log.d("upload cancel");
    }

    public boolean cancel(boolean interrupt) {
        if (this.cancelled || this.complete) {
            return false;
        }
        this.cancelled = true;
        if (interrupt) {
            this.interruptImmediately();
        } else if (this.future != null) {
            this.future.cancel(false);
        }
        this.onCancelled();
        return true;
    }

    public void interruptImmediately() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void publishProgress(int percentage) {
        this.onProgressUpdate(percentage);
    }

    static {
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(true);
        }
    }
}

