/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVRelation;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.AddRelationOp;
import com.avos.avoscloud.ops.CollectionOp;
import com.avos.avoscloud.ops.CompoundOp;
import com.avos.avoscloud.ops.NullOP;
import com.avos.avoscloud.ops.RemoveRelationOp;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AVObjectDeserializer
implements ObjectDeserializer {
    static final String LOG_TAG = AVObjectDeserializer.class.getSimpleName();
    public static final AVObjectDeserializer instance = new AVObjectDeserializer();

    AVObjectDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (AVObject.class.isAssignableFrom((Class)type)) {
            HashMap objectMap = new HashMap();
            parser.parseObject(objectMap);
            AVObject object = null;
            try {
                object = (AVObject)((Class)type).newInstance();
                object.setClassName((String)objectMap.get("className"));
                object.setObjectId((String)objectMap.get("objectId"));
                object.setCreatedAt((String)objectMap.get("createdAt"));
                object.setUpdatedAt((String)objectMap.get("updatedAt"));
                if (objectMap.containsKey("keyValues")) {
                    Map keyValues = (Map)objectMap.get("keyValues");
                    for (Map.Entry entry : keyValues.entrySet()) {
                        JSONObject keyValue = (JSONObject)entry.getValue();
                        Object values = keyValue.get((Object)"value");
                        AVOp op = null;
                        try {
                            op = (AVOp)keyValue.get((Object)"op");
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (op != null && !(op instanceof NullOP)) {
                            op = this.updateOp(op, values);
                            object.operationQueue.put((String)entry.getKey(), op);
                            continue;
                        }
                        if (!keyValue.containsKey((Object)"relationClassName")) {
                            object.serverData.put((String)entry.getKey(), values);
                            continue;
                        }
                        if (!keyValue.containsKey((Object)"relationClassName")) continue;
                        AVRelation relation = new AVRelation(object, (String)entry.getKey());
                        relation.setTargetClass(keyValue.getString("relationClassName"));
                        object.serverData.put((String)entry.getKey(), relation);
                    }
                } else {
                    if (objectMap.containsKey("operationQueue")) {
                        object.operationQueue.putAll((Map)objectMap.get("operationQueue"));
                    }
                    if (objectMap.containsKey("serverData")) {
                        object.serverData.putAll((Map)objectMap.get("serverData"));
                    }
                }
                object.rebuildInstanceData();
            }
            catch (InstantiationException e) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.log.e(LOG_TAG, "", e);
                }
            }
            catch (IllegalAccessException e) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.log.e(LOG_TAG, "", e);
                }
            }
            catch (Exception e) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.log.e(LOG_TAG, "", e);
                }
            }
            finally {
                return (T)object;
            }
        }
        return (T)parser.parseObject();
    }

    public int getFastMatchToken() {
        return 12;
    }

    public AVOp updateOp(AVOp op, Object values) {
        if (op instanceof AddRelationOp || op instanceof RemoveRelationOp) {
            try {
                Set opValues = (Set)op.getValues();
                HashSet<AVObject> objects = new HashSet<AVObject>();
                for (JSONObject o : opValues) {
                    AVObject object = (AVObject)JSONObject.parseObject((String)o.toString(), AVObject.class);
                    objects.add(object);
                }
                ((CollectionOp)op).setValues(objects);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (op instanceof CompoundOp) {
            List ops = (List)op.getValues();
            for (AVOp singleOp : ops) {
                this.updateOp(singleOp, null);
            }
        }
        return op;
    }
}

