/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Looper;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import org.apache.http.Header;

public class AVNetworkHelper {
    static final long TWENTY_MIN_IN_MILLS = 1200000L;
    static final long TEN_MIN_IN_NANO = 600000000000L;
    static final String AVOS_SERVER_HOST_ZONE = "avoscloud_server_host_zone";
    public static final String EXPIRE_TIME = ".expireTime";

    public static void amendDNS(final String url, final DNSUpdateCallback callback) {
        AVNetworkHelper.getDNSResource(url, new NetworkResourceCallback(){

            @Override
            public void done(String response, AVException e) {
                if (e == null) {
                    InetAddress[] addresses = AVNetworkHelper.getIPAddress(url, response);
                    if (addresses != null) {
                        try {
                            AVNetworkHelper.bindDNS(url, addresses);
                            callback.done(null);
                        }
                        catch (Exception ex) {
                            callback.done(new AVException(ex));
                        }
                    } else {
                        callback.done(new AVException(-1, "address parse failure"));
                    }
                } else {
                    callback.done(e);
                }
            }
        });
    }

    private static void bindDNS(String url, InetAddress[] addressArray) throws Exception {
        InetAddress[] addresses = addressArray;
        Constructor constructor = InetAddress.class.getDeclaredConstructor(Integer.TYPE, byte[].class, String.class);
        Field field = InetAddress.class.getDeclaredField("addressCache");
        field.setAccessible(true);
        Class<?> cacheClass = Class.forName("java.net.AddressCache");
        Field cacheField = cacheClass.getDeclaredField("cache");
        cacheField.setAccessible(true);
        Object addressCacheObject = field.get(null);
        Object BasicLruCacheObject = cacheField.get(addressCacheObject);
        Class<?> basicLruCacheClass = Class.forName("libcore.util.BasicLruCache");
        Class<?> addressCacheEntryClass = Class.forName("java.net.AddressCache$AddressCacheEntry");
        Field addressCacheEntryExpiredField = addressCacheEntryClass.getDeclaredField("expiryNanos");
        addressCacheEntryExpiredField.setAccessible(true);
        Constructor<?> addressCacheEntryConstructor = addressCacheEntryClass.getDeclaredConstructor(Object.class);
        addressCacheEntryConstructor.setAccessible(true);
        Method basicLruCachePutMethod = basicLruCacheClass.getDeclaredMethod("put", Object.class, Object.class);
        basicLruCachePutMethod.setAccessible(true);
        Object addressCacheEntry = addressCacheEntryConstructor.newInstance(new Object[]{addresses});
        addressCacheEntryExpiredField.set(addressCacheEntry, System.nanoTime() + 600000000000L);
        try {
            Class<?> addressCacheKeyClass = Class.forName("java.net.AddressCache$AddressCacheKey");
            Constructor<?> addressCacheKeyConstructor = addressCacheKeyClass.getDeclaredConstructor(String.class, Integer.TYPE);
            addressCacheKeyConstructor.setAccessible(true);
            Object addressCacheKey = addressCacheKeyConstructor.newInstance(url, 0);
            basicLruCachePutMethod.invoke(BasicLruCacheObject, addressCacheKey, addressCacheEntry);
        }
        catch (Exception e) {
            if (AVOSCloud.showInternalDebugLog()) {
                LogUtil.avlog.d(e.getMessage());
            }
            basicLruCachePutMethod.invoke(BasicLruCacheObject, url, addressCacheEntry);
        }
    }

    private static void getDNSResource(String url, final NetworkResourceCallback callback) {
        String response = AVPersistenceUtils.sharedInstance().getPersistentSettingString(AVOS_SERVER_HOST_ZONE, url, null);
        String expiredAt = AVPersistenceUtils.sharedInstance().getPersistentSettingString(AVOS_SERVER_HOST_ZONE, url + EXPIRE_TIME, "0");
        if (!AVUtils.isBlankString(response) && System.currentTimeMillis() < Long.parseLong(expiredAt)) {
            callback.done(response, null);
        } else {
            RequestParams params = new RequestParams();
            params.put("dn", url);
            AVUtils.getDirectlyClientForUse().get("http://119.29.29.29/d", params, (ResponseHandlerInterface)new AsyncHttpResponseHandler(Looper.getMainLooper()){

                public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                    if (statusCode == 200) {
                        callback.done(AVUtils.stringFromBytes(responseBody), null);
                    } else {
                        callback.done(null, new AVException(statusCode, AVUtils.stringFromBytes(responseBody)));
                    }
                }

                public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                    callback.done(null, new AVException(error));
                }
            });
        }
    }

    private static InetAddress[] getIPAddress(String url, String response) {
        try {
            String[] ips = response.split(";");
            InetAddress[] addresses = new InetAddress[ips.length];
            Constructor constructor = InetAddress.class.getDeclaredConstructor(Integer.TYPE, byte[].class, String.class);
            constructor.setAccessible(true);
            for (int i = 0; i < ips.length; ++i) {
                String ip = ips[i];
                String[] ipSegment = ip.split("\\.");
                if (ipSegment.length == 4) {
                    byte[] ipInBytes = new byte[]{(byte)Integer.parseInt(ipSegment[0]), (byte)Integer.parseInt(ipSegment[1]), (byte)Integer.parseInt(ipSegment[2]), (byte)Integer.parseInt(ipSegment[3])};
                    addresses[i] = (InetAddress)constructor.newInstance(2, ipInBytes, url);
                    continue;
                }
                if (!AVOSCloud.showInternalDebugLog()) continue;
                LogUtil.avlog.d("wrong IP Address");
            }
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(AVOS_SERVER_HOST_ZONE, url, response);
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(AVOS_SERVER_HOST_ZONE, url + EXPIRE_TIME, String.valueOf(System.currentTimeMillis() + 1200000L));
            return addresses;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static abstract class DNSUpdateCallback
    extends AVCallback<Void> {
        public abstract void done(AVException var1);

        @Override
        protected final void internalDone0(Void returnValue, AVException e) {
            this.done(e);
        }
    }

    public static interface NetworkResourceCallback {
        public void done(String var1, AVException var2);
    }
}

