/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;

class AVMultiPartEntity
extends MultipartEntity {
    private final ProgressListener listener;

    public AVMultiPartEntity(ProgressListener listener) {
        this.listener = listener;
    }

    public AVMultiPartEntity(HttpMultipartMode mode, ProgressListener listener) {
        super(mode);
        this.listener = listener;
    }

    public AVMultiPartEntity(HttpMultipartMode mode, String boundary, Charset charset, ProgressListener listener) {
        super(mode, boundary, charset);
        this.listener = listener;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        super.writeTo((OutputStream)new CountingOutputStream(outstream, this.listener));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long transferred;

        public CountingOutputStream(OutputStream out, ProgressListener listener) {
            super(out);
            this.listener = listener;
            this.transferred = 0L;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            this.listener.transferred(this.transferred);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);
    }
}

