/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFriendship;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.QueryConditions;
import com.avos.avoscloud.QueryOperation;
import com.avos.avoscloud.callback.AVFriendshipCallback;
import com.loopj.android.http.RequestParams;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AVFriendshipQuery<T extends AVUser> {
    String userId;
    Class<T> userClazz;
    QueryConditions conditions;

    AVFriendshipQuery(String userId) {
        this(userId, null);
    }

    AVFriendshipQuery(String userId, Class<T> clazz) {
        this.userId = userId;
        this.userClazz = clazz;
        this.conditions = new QueryConditions();
    }

    protected void getInBackground(String objectId, boolean sync, AVFriendshipCallback callback) {
        String path = String.format("users/%s/followersAndFollowees", objectId);
        final AVFriendshipCallback internalCallback = callback;
        this.conditions.assembleParameters();
        PaasClient.storageInstance().getObject(path, new RequestParams(this.conditions.getParameters()), sync, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                AVException error;
                AVFriendship friendship;
                block8: {
                    friendship = null;
                    error = e;
                    if (AVUtils.isBlankContent(content)) {
                        friendship = null;
                        error = new AVException(101, "Object is not found.");
                    } else {
                        try {
                            friendship = new AVFriendship();
                            AVFriendship.AVFriendshipResponse response = (AVFriendship.AVFriendshipResponse)JSON.parseObject((String)content, AVFriendship.AVFriendshipResponse.class);
                            if (AVFriendshipQuery.this.userClazz != null) {
                                List followers = friendship.getFollowers();
                                List followees = friendship.getFollowees();
                                for (Map<String, Object> followerShip : response.followers) {
                                    Object follower = AVUser.newAVUser(AVFriendshipQuery.this.userClazz, null);
                                    AVUtils.copyPropertiesFromMapToAVObject((Map)followerShip.get("follower"), follower);
                                    followers.add(follower);
                                    if (friendship.getUser() != null) continue;
                                    Object user = AVUser.newAVUser(AVFriendshipQuery.this.userClazz, null);
                                    AVUtils.copyPropertiesFromMapToAVObject((Map)followerShip.get("user"), user);
                                    friendship.setUser((AVUser)user);
                                }
                                friendship.setFollowers(followers);
                                for (Map<String, Object> followeeShip : response.followees) {
                                    Object followee = AVUser.newAVUser(AVFriendshipQuery.this.userClazz, null);
                                    AVUtils.copyPropertiesFromMapToAVObject((Map)followeeShip.get("followee"), followee);
                                    followees.add(followee);
                                }
                                friendship.setFollowees(followees);
                            }
                        }
                        catch (Exception e1) {
                            if (internalCallback == null) break block8;
                            internalCallback.internalDone(null, AVErrorUtils.createException(e1, content));
                        }
                    }
                }
                if (internalCallback != null) {
                    internalCallback.internalDone(friendship, error);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public AVFriendship get() throws AVException {
        final Object[] result = new Object[]{null};
        this.getInBackground(this.userId, true, new AVFriendshipCallback(){

            @Override
            public void done(AVFriendship object, AVException e) {
                if (e == null) {
                    result[0] = object;
                } else {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (AVFriendship)result[0];
    }

    public void getInBackground(AVFriendshipCallback callback) {
        this.getInBackground(this.userId, false, callback);
    }

    public int getLimit() {
        return this.conditions.getLimit();
    }

    public AVFriendshipQuery<T> setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public AVFriendshipQuery<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public AVFriendshipQuery<T> skip(int skip) {
        this.setSkip(skip);
        return this;
    }

    public int getSkip() {
        return this.conditions.getSkip();
    }

    public AVFriendshipQuery<T> setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public String getOrder() {
        return this.conditions.getOrder();
    }

    public AVFriendshipQuery<T> setOrder(String order) {
        this.conditions.setOrder(order);
        return this;
    }

    public AVFriendshipQuery<T> order(String order) {
        this.setOrder(order);
        return this;
    }

    public AVFriendshipQuery<T> addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(key);
        return this;
    }

    public AVFriendshipQuery<T> addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(key);
        return this;
    }

    public AVFriendshipQuery<T> include(String key) {
        this.conditions.include(key);
        return this;
    }

    public AVFriendshipQuery<T> selectKeys(Collection<String> keys) {
        this.conditions.selectKeys(keys);
        return this;
    }

    public AVFriendshipQuery<T> orderByAscending(String key) {
        this.conditions.orderByAscending(key);
        return this;
    }

    public AVFriendshipQuery<T> orderByDescending(String key) {
        this.conditions.orderByDescending(key);
        return this;
    }

    public AVFriendshipQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereContainedIn(key, values);
        return this;
    }

    public AVFriendshipQuery<T> whereContains(String key, String substring) {
        this.conditions.whereContains(key, substring);
        return this;
    }

    public AVFriendshipQuery<T> whereSizeEqual(String key, int size) {
        this.conditions.whereSizeEqual(key, size);
        return this;
    }

    public AVFriendshipQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.conditions.whereContainsAll(key, values);
        return this;
    }

    public AVFriendshipQuery<T> whereDoesNotExist(String key) {
        this.conditions.whereDoesNotExist(key);
        return this;
    }

    public AVFriendshipQuery<T> whereEndsWith(String key, String suffix) {
        this.conditions.whereEndsWith(key, suffix);
        return this;
    }

    public AVFriendshipQuery<T> whereEqualTo(String key, Object value) {
        if (value instanceof AVObject) {
            this.addWhereItem(key, "__eq", AVUtils.mapFromPointerObject((AVObject)value));
        } else {
            this.addWhereItem(key, "__eq", value);
        }
        return this;
    }

    private AVFriendshipQuery<T> addWhereItem(QueryOperation op) {
        this.conditions.addWhereItem(op);
        return this;
    }

    private AVFriendshipQuery<T> addOrItems(QueryOperation op) {
        this.conditions.addOrItems(op);
        return this;
    }

    protected AVFriendshipQuery<T> addWhereItem(String key, String op, Object value) {
        return this.addWhereItem(new QueryOperation(key, op, value));
    }

    public AVFriendshipQuery<T> whereExists(String key) {
        this.conditions.whereExists(key);
        return this;
    }

    public AVFriendshipQuery<T> whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(key, value);
        return this;
    }

    public AVFriendshipQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public AVFriendshipQuery<T> whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(key, value);
        return this;
    }

    public AVFriendshipQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(key, value);
        return this;
    }

    public AVFriendshipQuery<T> whereMatches(String key, String regex) {
        this.conditions.whereMatches(key, regex);
        return this;
    }

    public AVFriendshipQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(key, regex, modifiers);
        return this;
    }

    public AVFriendshipQuery<T> whereNear(String key, AVGeoPoint point) {
        this.conditions.whereNear(key, point);
        return this;
    }

    public AVFriendshipQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereNotContainedIn(key, values);
        return this;
    }

    public AVFriendshipQuery<T> whereNotEqualTo(String key, Object value) {
        this.conditions.whereNotEqualTo(key, value);
        return this;
    }

    public AVFriendshipQuery<T> whereStartsWith(String key, String prefix) {
        this.conditions.whereStartsWith(key, prefix);
        return this;
    }

    public AVFriendshipQuery<T> whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        this.conditions.whereWithinGeoBox(key, southwest, northeast);
        return this;
    }

    public AVFriendshipQuery<T> whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public AVFriendshipQuery<T> whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance);
        return this;
    }

    public AVFriendshipQuery<T> whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance);
        return this;
    }
}

