/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogInCallback;
import com.avos.avoscloud.PaasClient;
import java.util.UUID;

public class AVAnonymousUtils {
    private static String anonymousAuthData() {
        String json = String.format("{\"authData\": {\"anonymous\" : {\"id\": \"%s\"}}}", UUID.randomUUID().toString().toLowerCase());
        return json;
    }

    public static boolean isLinked(AVUser user) {
        return user == AVUser.getCurrentUser() && user.isAuthenticated() && user.isAnonymous();
    }

    public static void logIn(LogInCallback<AVUser> callback) {
        final LogInCallback<AVUser> internalCallback = callback;
        String string = AVAnonymousUtils.anonymousAuthData();
        PaasClient.storageInstance().postObject("users", string, false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                Object user = AVUser.newAVUser();
                AVUtils.copyPropertiesFromJsonStringToAVObject(content, user);
                ((AVUser)user).setAnonymous(true);
                AVUser.changeCurrentUser(user, true);
                if (internalCallback != null) {
                    internalCallback.internalDone(user, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }
}

