package com.basic.widgets;

import android.content.Context;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.ArrayList;

import com.basic.util.CommonUtil;

public class WheelTextAdapter extends BaseAdapter {
  ArrayList<WheelTextInfo> data = null;
  int width = ViewGroup.LayoutParams.MATCH_PARENT;
  int height = 50;
  Context context = null;

  public WheelTextAdapter(Context context) {
    this.context = context;
    height = (int) CommonUtil.pixelToDp(context, height);
  }

  public void setData(ArrayList<WheelTextInfo> data) {
    this.data = data;
    this.notifyDataSetChanged();
  }

  public void setItemSize(int width, int height) {
    this.width = width;
    this.height = (int) CommonUtil.pixelToDp(context, height);
  }

  @Override
  public int getCount() {
    return (null != data) ? data.size() : 0;
  }

  @Override
  public Object getItem(int position) {
    return null;
  }

  @Override
  public long getItemId(int position) {
    return 0;
  }

  @Override
  public View getView(int position, View convertView, ViewGroup parent) {
    TextView textView = null;

    if (null == convertView) {
      convertView = new TextView(context);
      convertView.setLayoutParams(new TosGallery.LayoutParams(width, height));
      textView = (TextView) convertView;
      textView.setGravity(Gravity.CENTER);
      textView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 20);
      textView.setTextColor(Color.GRAY);
    }

    if (null == textView) {
      textView = (TextView) convertView;
    }

    WheelTextInfo info = data.get(position);
    textView.setText(info.text);
//      if(info.isSelected){
//        textView.setTextColor(Color.BLUE);
//      }else{
//        textView.setTextColor(Color.BLACK);
//      }

    return convertView;
  }
}
