package com.basic.widgets;

import android.app.Activity;
import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.base.libs.R;
import com.basic.application.BaseApplication;

/**
 * 自定义弹出框，将this放入dialog的contentView，使用popupwindow方式，不能使用自定义键盘
 *
 * @author Administrator
 */
public class BaseAlertViewPopup extends LinearLayout {

  protected PopupWindow dialog;
  protected BaseAlertCallback callback;

  public BaseAlertViewPopup(Context context) {
    super(context);
    setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));

    dialog = new PopupWindow(this, LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
    dialog.setClippingEnabled(true);
    dialog.setFocusable(true);
    dialog.setTouchable(true);
    dialog.setBackgroundDrawable(context.getResources().getDrawable(R.drawable.alert_view_bg));
  }

  public void setBackgroundDrawable(int drawableId) {
    dialog.setBackgroundDrawable(getContext().getResources().getDrawable(drawableId));
  }

  public void show(BaseAlertCallback cb) {
    showByAnimation(cb, R.anim.popup_from_bottom, null);
  }

  public void showOnDialog(View view, BaseAlertCallback cb) {
    showByAnimation(cb, R.anim.popup_from_bottom, view);
  }

  public void showByAnimation(BaseAlertCallback cb, int animationId,
                              View dialogView) {
    callback = cb;
    if (dialog == null || dialog.isShowing()) {
      return;
    }

    Activity activity = (Activity) getContext();
    BaseApplication baseApplication = (BaseApplication) activity.getApplication();

    if (!baseApplication.getActivityShowMap().get(activity.getLocalClassName())) {
      //该activity已进入后台
      return;
    }

    View view = activity.getWindow().getDecorView();
    if (view == null || view.getWindowToken() == null) {
      return;
    }

    if (dialogView != null) {
      view = dialogView;
      dialog.setWindowLayoutMode(ViewGroup.LayoutParams.WRAP_CONTENT,
          ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    dialog.showAtLocation(view, Gravity.CENTER, 0, 0);
    if (animationId > 0) {
      dialog.getContentView().startAnimation(
          AnimationUtils.loadAnimation(getContext(), animationId));
    }
    dialog.getContentView().setEnabled(true);
  }

  public void dismissByAnimation() {
    dismissByAnimation(R.anim.dismiss_to_bottom);
  }

  public void dismissByAnimation(int id) {
    if (dialog == null || !dialog.isShowing()) {
      return;
    }

    if (id == 0) {
      dialog.getContentView().post(new Runnable() {
        @Override
        public void run() {
          dismiss();
        }
      });
      dialog.getContentView().setEnabled(false);
      return;
    }

    Animation animation = AnimationUtils.loadAnimation(getContext(), id);
    animation.setAnimationListener(new Animation.AnimationListener() {
      @Override
      public void onAnimationStart(Animation animation) {}

      @Override
      public void onAnimationEnd(Animation animation) {
        dialog.getContentView().post(new Runnable() {
          @Override
          public void run() {
            dismiss();
          }
        });
      }

      @Override
      public void onAnimationRepeat(Animation animation) {}
    });
    dialog.getContentView().startAnimation(animation);
    dialog.getContentView().setEnabled(false);
  }

  public void dismiss() {
    if (dialog != null && dialog.isShowing()) {
      dialog.dismiss();
      dialog.getContentView().clearAnimation();
    }
  }

  public void destroy() {
    dismiss();
    dialog = null;
  }

  public View getContentView() {
    return dialog.getContentView();
  }
}
