package com.basic.widgets;

import android.graphics.Typeface;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.TextView;
import com.basic.util.CommonUtil;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class ActionBar {
  protected TextView barDefaultTitle;
  protected ImageViewButton barDefaultRightIcon;
  protected ImageViewButton barDefaultLeftIcon;

  public ActionBar(final AppCompatActivity activity,
                   int resourceId,
                   int barDefaultTitleId,
                   int barDefaultBackId,
                   int barDefaultRightIconId) {
    android.support.v7.app.ActionBar actionBar = activity.getSupportActionBar();
    if (actionBar != null) {
      actionBar.setDisplayOptions(
          android.support.v7.app.ActionBar.DISPLAY_SHOW_CUSTOM);
      actionBar.setCustomView(resourceId);

      barDefaultTitle = (TextView) activity.findViewById(barDefaultTitleId);

      barDefaultLeftIcon = (ImageViewButton) activity.findViewById(barDefaultBackId);
      barDefaultLeftIcon.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          if (CommonUtil.isFastDoubleClick()) {
            return;
          }

          activity.onBackPressed();
        }
      });

      barDefaultRightIcon =
          (ImageViewButton) activity.findViewById(barDefaultRightIconId);
    }
  }

  public void setTypeface(Typeface typeface) {
    barDefaultTitle.setTypeface(typeface);
  }

  public void setTitle(String title) {
    barDefaultTitle.setText(title);
  }

  public void showRightIcon(View.OnClickListener click) {
    barDefaultRightIcon.setVisibility(View.VISIBLE);
    barDefaultRightIcon.setOnClickListener(click);
  }
}
