package com.basic.util;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class TypeFaceUtil {
  private static final String PATH_TYPEFACE_REGULAR
      = "fonts/Bariol_Regular.otf";
  private static Typeface regularTypeface;

  public Typeface getRegularTypeface(Context context) {
    if (regularTypeface == null) {
      //Only do this once for each typeface used
      //or we will leak unnecessary memory.
      regularTypeface = Typeface.createFromAsset(
          context.getAssets(), PATH_TYPEFACE_REGULAR);
    }
    return regularTypeface;
  }

  private static final String PATH_TYPEFACE_LIGHT = "fonts/Bariol_Light.otf";
  private Typeface lightTypeface;

  public Typeface getLightTypeface(Context context) {
    if (lightTypeface == null) {
      lightTypeface = Typeface.createFromAsset(
          context.getAssets(), PATH_TYPEFACE_LIGHT);
    }
    return lightTypeface;
  }

  private static final String PATH_TYPEFACE_BOLD = "fonts/Bariol_Bold.otf";
  private Typeface boldTypeface;

  public Typeface getBoldTypeface(Context context) {
    if (boldTypeface == null) {
      boldTypeface = Typeface.createFromAsset(
          context.getAssets(), PATH_TYPEFACE_BOLD);
    }
    return boldTypeface;
  }

  private static final String PATH_TYPEFACE_BONGMI = "fonts/Bongmi.ttf";
  private Typeface bongmiTypeface;

  public Typeface getBongmiTypeface(Context context) {
    if (bongmiTypeface == null) {
      bongmiTypeface = Typeface.createFromAsset(
          context.getAssets(), PATH_TYPEFACE_BONGMI);
    }
    return bongmiTypeface;
  }

  public void setTypeFace(Typeface typeFace, ViewGroup parent) {
    for (int i = 0; i < parent.getChildCount(); i++) {
      View v = parent.getChildAt(i);
      if (v instanceof ViewGroup) {
        setTypeFace(typeFace, (ViewGroup) v);
      } else if (v instanceof TextView) {
        TextView tv = (TextView) v;
        tv.setTypeface(typeFace);
        //For making the font anti-aliased.
        tv.setPaintFlags(tv.getPaintFlags() | Paint.SUBPIXEL_TEXT_FLAG);
      }
    }
  }
}
