package com.basic.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;

public class NotifyUtil {

  public static void show(Context context, int icon_silhouette, int iconId, String tickerText,
                          boolean soundFlag, boolean vibrateFlag,
                          String contentTitle, String contentText, Intent intent) {

    //将该通知显示为默认View
    intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
    PendingIntent contentIntent = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT);

    NotificationManager mNotificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

    Notification.Builder builder = new Notification.Builder(context);
    builder.setSmallIcon(getNotificationIcon(icon_silhouette, iconId));
    builder.setTicker(tickerText);
    builder.setWhen(System.currentTimeMillis());
    int defaults = 0;
    if (soundFlag) {
      defaults |= Notification.DEFAULT_SOUND;
    }
    if (vibrateFlag) {
      defaults |= Notification.DEFAULT_VIBRATE;
    }
    builder.setDefaults(defaults);
    builder.setAutoCancel(true);
    builder.setContentIntent(contentIntent);
    builder.setContentTitle(contentTitle);
    builder.setContentText(contentText);
    builder.build();
    int i = CommonUtil.randomInt(5);
    mNotificationManager.notify(i, builder.getNotification());

    /*// 创建一个通知
    Notification mNotification = new Notification();

    // 设置属性值
    mNotification.icon = getNotificationIcon(icon_silhouette, iconId);
    mNotification.tickerText = tickerText;
    mNotification.when = System.currentTimeMillis(); // 立即发生此通知

    // 添加声音效果
    if (soundFlag) {
      mNotification.defaults |= Notification.DEFAULT_SOUND;
    }

    // 添加震动,后来得知需要添加震动权限 : Virbate Permission
    if (vibrateFlag) {
      mNotification.defaults |= Notification.DEFAULT_VIBRATE;
    }

    //添加状态标志

    //FLAG_AUTO_CANCEL          该通知能被状态栏的清除按钮给清除掉
    //FLAG_NO_CLEAR                 该通知能被状态栏的清除按钮给清除掉
    //FLAG_ONGOING_EVENT      通知放置在正在运行
    //FLAG_INSISTENT                通知的音乐效果一直播放
    mNotification.flags = Notification.FLAG_AUTO_CANCEL;

    mNotification.setLatestEventInfo(context, contentTitle, contentText, contentIntent);
    // 设置setLatestEventInfo方法,如果不设置会App报错异常


    //注册此通知
    // 如果该NOTIFICATION_ID的通知已存在，会显示最新通知的相关信息 ，比如tickerText 等
    int i = CommonUtil.randomInt(5);
    mNotificationManager.notify(i, mNotification);*/
  }

  private static int getNotificationIcon(int icon_silhouette, int icon) {
    boolean useWhiteIcon = (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP);
    return useWhiteIcon ? icon_silhouette : icon;
  }
}
