package com.basic.util;

import android.graphics.Rect;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewTreeObserver;

/**
 * Copyright (c) 2016, Bongmi
 * All rights reserved
 * Author: jianghao@bongmi.com
 */
public class LayoutUtil {
  /**
   * Expand the given child View's touchable area by the given padding, by
   * setting a TouchDelegate on the given ancestor View whenever its layout
   * changes.
   */
  public static void expandTouchArea(final View ancestorView,
                                     final View childView, final Rect padding) {

    ancestorView.getViewTreeObserver().addOnGlobalLayoutListener(
        new ViewTreeObserver.OnGlobalLayoutListener() {
          @Override
          public void onGlobalLayout() {
            TouchDelegate delegate = null;

            if (childView.isShown()) {
              // Get hitRect in parent's coordinates
              Rect hitRect = new Rect();
              childView.getHitRect(hitRect);

              // Translate to ancestor's coordinates
              int ancestorLoc[] = new int[2];
              ancestorView.getLocationInWindow(ancestorLoc);

              int parentLoc[] = new int[2];
              ((View)childView.getParent()).getLocationInWindow(
                  parentLoc);

              int xOffset = parentLoc[0] - ancestorLoc[0];
              hitRect.left += xOffset;
              hitRect.right += xOffset;

              int yOffset = parentLoc[1] - ancestorLoc[1];
              hitRect.top += yOffset;
              hitRect.bottom += yOffset;

              // Add padding
              hitRect.top -= padding.top;
              hitRect.bottom += padding.bottom;
              hitRect.left -= padding.left;
              hitRect.right += padding.right;

              delegate = new TouchDelegate(hitRect, childView);
            }

            ancestorView.setTouchDelegate(delegate);
          }
        });
  }
}
