package com.basic.util;

public class ClsUtil {

  private final static byte[] hex = "0123456789ABCDEF".getBytes();

  private static int parse(char c) {
    if (c >= 'a')
      return (c - 'a' + 10) & 0x0f;
    if (c >= 'A')
      return (c - 'A' + 10) & 0x0f;
    return (c - '0') & 0x0f;
  }

  // 从字节数组到十六进制字符串转换
  public static String Bytes2HexString(byte[] b) {
    if (b == null) {
      return null;
    }
    byte[] buff = new byte[2 * b.length];
    for (int i = 0; i < b.length; i++) {
      buff[2 * i] = hex[(b[i] >> 4) & 0x0f];
      buff[2 * i + 1] = hex[b[i] & 0x0f];
    }
    return new String(buff);
  }

  // 从十六进制字符串到字节数组转换
  public static byte[] HexString2Bytes(String hexstr) {
    if (hexstr == null) {
      return null;
    }
    byte[] b = new byte[hexstr.length() / 2];
    int j = 0;
    for (int i = 0; i < b.length; i++) {
      char c0 = hexstr.charAt(j++);
      char c1 = hexstr.charAt(j++);
      b[i] = (byte) ((parse(c0) << 4) | parse(c1));
    }
    return b;
  }

  /**
   * ascii转成十六进制
   *
   * @param str string
   * @return string
   */
  public static String convertStringToHex(String str) {
    if (str == null) {
      return null;
    }

    char[] chars = str.toCharArray();

    StringBuffer hex = new StringBuffer();
    for (int i = 0; i < chars.length; i++) {
      hex.append(Integer.toHexString((int) chars[i]));
    }

    return hex.toString();
  }

  /**
   * 十六进制转成ascii
   *
   * @param hex hex
   * @return string
   */
  public static String convertHexToString(String hex) {
    if (hex == null) {
      return null;
    }

    StringBuilder sb = new StringBuilder();
    StringBuilder temp = new StringBuilder();

    //49204c6f7665204a617661 split into two characters 49, 20, 4c...
    for (int i = 0; i < hex.length() - 1; i += 2) {

      //grab the hex in pairs
      String output = hex.substring(i, (i + 2));
      //convert hex to decimal
      int decimal = Integer.parseInt(output, 16);
      //convert the decimal to character
      sb.append((char) decimal);

      temp.append(decimal);
    }

    return sb.toString();
  }

  //504F533838383834  POS88884
  public static void main(String[] args) {

    System.out.println("\n-----ASCII码转换为16进制 -----");
    String str = "POS88884";
    System.out.println("字符串: " + str);
    String hex = convertStringToHex(str);
    System.out.println("转换为16进制 : " + hex);

    System.out.println("\n***** 16进制转换为ASCII *****");
    System.out.println("Hex : " + hex);
    System.out.println("ASCII : " + convertHexToString(hex));
  }
} 