package com.basic.util;

import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class AnimationsLoop {

  private View view;
  private Animation goAnimation;
  private Animation backAnimation;

  public AnimationsLoop(Context context, View v, int goAnimationId, int backAnimationId) {
    view = v;
    goAnimation = AnimationUtils.loadAnimation(context, goAnimationId);
    Animation.AnimationListener goListener = new Animation.AnimationListener() {
      @Override
      public void onAnimationStart(Animation animation) {}

      @Override
      public void onAnimationEnd(Animation animation) {
        view.startAnimation(backAnimation);
      }

      @Override
      public void onAnimationRepeat(Animation animation) {}
    };
    goAnimation.setAnimationListener(goListener);
    backAnimation = AnimationUtils.loadAnimation(context, backAnimationId);
    Animation.AnimationListener backListener = new Animation.AnimationListener() {
      @Override
      public void onAnimationStart(Animation animation) {}

      @Override
      public void onAnimationEnd(Animation animation) {
        view.startAnimation(goAnimation);
      }

      @Override
      public void onAnimationRepeat(Animation animation) {}
    };
    backAnimation.setAnimationListener(backListener);
  }

  public void start() {
    view.startAnimation(goAnimation);
  }

  public void end() {
    view.clearAnimation();
  }
}
