package com.basic.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.multidex.MultiDex;
import android.support.multidex.MultiDexApplication;
import android.view.ViewGroup;
import com.basic.util.TypeFaceUtil;

public class BaseApplication extends MultiDexApplication {

  protected final Map<String, Boolean> activityShowMap = new HashMap<>();
  private int resumedCount;
  private final TypeFaceUtil typeFaceUtil = new TypeFaceUtil();

  private final Properties config = new Properties();

  @Override
  protected void attachBaseContext(Context base) {
    super.attachBaseContext(base);
    MultiDex.install(this);
  }

  @Override
  public void onCreate() {
    super.onCreate();

    initConfig();

    registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
  }

  private void initConfig() {
    try {
      InputStream in = getAssets().open("config.properties");
      config.load(in);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public String getConfigProperty(String name) {
    return config.getProperty(name);
  }

  public int getConfigColor(String name) {
    return Color.parseColor(config.getProperty(name));
  }

  private ActivityLifecycleCallbacks activityLifecycleCallbacks =
      new ActivityLifecycleCallbacks() {
        @Override
        public void onActivityCreated(Activity activity,
                                      Bundle savedInstanceState) {}

        @Override
        public void onActivityStarted(Activity activity) {
          if (resumedCount == 0) {
            showApplication();
          }
          resumedCount++;
        }

        @Override
        public void onActivityResumed(Activity activity) {
          activityShowMap.put(activity.getLocalClassName(), true);
        }

        @Override
        public void onActivityPaused(Activity activity) {
          activityShowMap.put(activity.getLocalClassName(), false);
        }

        @Override
        public void onActivityStopped(Activity activity) {
          resumedCount--;
          if (resumedCount == 0) {
            gotoBackground();
          }
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
        }
      };

  protected void showApplication() {}

  protected void gotoBackground() {}

  public Map<String, Boolean> getActivityShowMap() {
    return activityShowMap;
  }

  public Typeface getRegularTypeface() {
    return typeFaceUtil.getRegularTypeface(this);
  }

  public Typeface getLightTypeface() {
    return typeFaceUtil.getLightTypeface(this);
  }

  public Typeface getBoldTypeface() {
    return typeFaceUtil.getBoldTypeface(this);
  }

  public Typeface getBongmiTypeface() {
    return typeFaceUtil.getBongmiTypeface(this);
  }

  public void setTypeFace(Typeface typeFace, ViewGroup parent) {
    typeFaceUtil.setTypeFace(typeFace, parent);
  }
}