/*
 * Decompiled with CFR 0.152.
 */
package cn.kejin.android.views;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.LinearInterpolator;
import cn.kejin.android.views.BitmapManager;
import cn.kejin.android.views.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class XImageView
extends View {
    public static final String TAG = "SuperImageView";
    private static final int DOUBLE_SCALE_TIME = 400;
    private XGestureDetector mGestureDetector = null;
    private OnActionListener mActionListener = null;
    private BitmapManager mBitmapManager = null;
    private boolean mInitFitView = false;
    private TYPE_FIT mDoubleTapScaleType = TYPE_FIT.FIT_VIEW;
    private float mDisplayDensity = 1.0f;
    private static final Paint mPaint = new Paint();
    private BitmapManager.IManagerCallback mManagerCallback = new BitmapManager.IManagerCallback(){

        @Override
        public void onSetImageStart() {
            if (XImageView.this.mActionListener != null) {
                XImageView.this.mActionListener.onSetImageStart(XImageView.this);
            }
        }

        @Override
        public void onSetImageFinished(BitmapManager bm, boolean success, Rect image) {
            if (bm == XImageView.this.mBitmapManager && XImageView.this.mActionListener != null) {
                XImageView.this.mActionListener.onSetImageFinished(XImageView.this, success, image);
            }
        }
    };
    private XOnGestureListener mGestureListener = new XOnGestureListener();
    private float mPhysicalCoeff;
    private float mFlingFriction = ViewConfiguration.getScrollFriction();
    private static final float DECELERATION_RATE;
    private static final float INFLEXION = 0.35f;
    private ValueAnimator mValueAnimator = null;

    public XImageView(Context context) {
        this(context, null, 0);
    }

    public XImageView(Context context, boolean initFitView) {
        this(context, null, 0);
        this.mInitFitView = initFitView;
    }

    public XImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XImageView);
            this.mInitFitView = ta.getBoolean(R.styleable.XImageView_initFitView, false);
            int type = ta.getInt(R.styleable.XImageView_doubleTapScaleType, TYPE_FIT.FIT_VIEW.mType);
            this.mDoubleTapScaleType = type == 0 ? TYPE_FIT.FIT_VIEW : TYPE_FIT.FIT_IMAGE;
            ta.recycle();
        }
        this.mDisplayDensity = context.getResources().getDisplayMetrics().density;
        float dpi = this.mDisplayDensity * 160.0f;
        this.mPhysicalCoeff = 386.0878f * dpi * 0.84f;
        this.mGestureDetector = new XGestureDetector(context);
        super.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return false;
            }
        });
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                if (this.mBitmapManager == null || this.mBitmapManager.checkImageNotAvailable()) break;
                this.interceptParentTouchEvent(true);
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.interceptParentTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mBitmapManager != null) {
            boolean bl = this.mBitmapManager.drawVisibleBitmap(canvas, width, height);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmapManager != null) {
            this.mBitmapManager.onDestroy();
        }
    }

    private void interceptParentTouchEvent(boolean intercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(intercept);
        }
    }

    public void setImage(Bitmap bitmap) {
        this.setImage(bitmap, false);
    }

    public void setImage(Bitmap bitmap, boolean cache) {
        if (this.mBitmapManager != null) {
            this.mBitmapManager.onDestroy();
        }
        this.mBitmapManager = new BitmapManager((View)this, bitmap, cache, this.mManagerCallback);
        this.mBitmapManager.setInitFitView(this.mInitFitView);
    }

    public void setImage(String path) {
        this.setImage(new File(path), Bitmap.Config.RGB_565);
    }

    public void setImage(String path, Bitmap.Config config) {
        this.setImage(new File(path), config);
    }

    public void setImage(File file) {
        this.setImage(file, Bitmap.Config.RGB_565);
    }

    public void setImage(File file, Bitmap.Config config) {
        if (file == null || !file.exists()) {
            this.setImage((InputStream)null, config);
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            this.setImage(fis, config);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setImage(InputStream inputStream) {
        this.setImage(inputStream, Bitmap.Config.RGB_565);
    }

    public void setImage(InputStream is, Bitmap.Config config) {
        if (this.mBitmapManager != null) {
            this.mBitmapManager.onDestroy();
        }
        this.mBitmapManager = new BitmapManager((View)this, is, config, this.mManagerCallback);
        this.mBitmapManager.setInitFitView(this.mInitFitView);
    }

    public void setActionListener(OnActionListener listener) {
        this.mActionListener = listener;
    }

    public void scaleImage(float dest, boolean smooth, int smoothTime) {
        if (this.mBitmapManager != null) {
            this.mBitmapManager.scaleFromCenterTo(dest, smooth, smoothTime);
        }
    }

    public void scaleImage(int cx, int cy, float dest, boolean smooth, int smoothTime) {
        if (this.mBitmapManager != null) {
            this.mBitmapManager.scaleTo(cx, cy, dest, smooth, smoothTime);
        }
    }

    public void scaleToMaxFitView(int cx, int cy, boolean smooth, int smoothTime) {
        if (this.mBitmapManager != null) {
            this.mBitmapManager.scaleToMaxFitView(cx, cy, smooth, smoothTime);
        }
    }

    public void scaleToMinFitView(int cx, int cy, boolean smooth, int smoothTime) {
        if (this.mBitmapManager != null) {
            this.mBitmapManager.scaleToMinFitView(cx, cy, smooth, smoothTime);
        }
    }

    public int scrollImage(int dx, int dy) {
        return this.mBitmapManager != null ? this.mBitmapManager.offsetShowBitmap(dx, dy) : 0;
    }

    public float getScaleFactor() {
        return this.mBitmapManager != null ? this.mBitmapManager.getCurScaleFactor() : 0.0f;
    }

    public Rect getRealImageRect() {
        return this.mBitmapManager != null ? this.mBitmapManager.getImageRect() : new Rect();
    }

    public Rect getShowImageRect() {
        return this.mBitmapManager != null ? this.mBitmapManager.getShowImageRect() : new Rect();
    }

    public boolean isSettingImage() {
        return this.mBitmapManager != null && this.mBitmapManager.isSettingImage();
    }

    public void setInitFitView(boolean fitView) {
        this.mInitFitView = fitView;
        if (this.mBitmapManager != null) {
            this.mBitmapManager.setInitFitView(this.mInitFitView);
        }
    }

    public void setDoubleTapScaleType(TYPE_FIT type) {
        this.mDoubleTapScaleType = type == null ? TYPE_FIT.FIT_VIEW : type;
    }

    private void stopFling() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.cancel();
        }
    }

    private void startFling(final float velocityX, final float velocityY) {
        this.stopFling();
        final float fx = velocityX < 0.0f ? 1 : -1;
        final float fy = velocityY < 0.0f ? 1 : -1;
        float velocity = (float)Math.hypot(velocityX, velocityY);
        long duration = this.getSplineFlingDuration(velocity);
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mValueAnimator.setDuration(duration);
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private Double mLastDisX = Double.NaN;
            private Double mLastDisY = Double.NaN;

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                double curDisX = XImageView.this.getSplineFlingDistance(value * velocityX) * (double)fx;
                double curDisY = XImageView.this.getSplineFlingDistance(value * velocityY) * (double)fy;
                if (this.mLastDisX.isNaN() || this.mLastDisY.isNaN()) {
                    this.mLastDisX = curDisX;
                    this.mLastDisY = curDisY;
                    return;
                }
                int dx = (int)(curDisX - this.mLastDisX);
                int dy = (int)(curDisY - this.mLastDisY);
                if (XImageView.this.mBitmapManager != null) {
                    XImageView.this.mBitmapManager.offsetShowBitmap(dx, dy);
                }
                this.mLastDisX = curDisX;
                this.mLastDisY = curDisY;
            }
        });
        this.mValueAnimator.start();
    }

    private double getSplineDeceleration(float velocity) {
        return Math.log(0.35f * Math.abs(velocity) / (this.mFlingFriction * this.mPhysicalCoeff));
    }

    private int getSplineFlingDuration(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (int)(1000.0 * Math.exp(l / decelMinusOne));
    }

    private double getSplineFlingDistance(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / decelMinusOne * l);
    }

    private int dpToPx(float dp) {
        return (int)(dp * this.mDisplayDensity + 0.5f);
    }

    private int pxToDp(float px) {
        return (int)(px / this.mDisplayDensity + 0.5f);
    }

    static {
        mPaint.setAntiAlias(true);
        mPaint.setColor(-1);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeWidth(2.0f);
        DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
    }

    public static class SimpleActionListener
    implements OnActionListener {
        @Override
        public void onSingleTapped(XImageView view, MotionEvent event, boolean onImage) {
        }

        @Override
        public boolean onDoubleTapped(XImageView view, MotionEvent event) {
            return false;
        }

        @Override
        public void onLongPressed(XImageView view, MotionEvent event) {
        }

        @Override
        public void onSetImageStart(XImageView view) {
        }

        @Override
        public void onSetImageFinished(XImageView view, boolean success, Rect image) {
        }
    }

    public static interface OnActionListener {
        public void onSingleTapped(XImageView var1, MotionEvent var2, boolean var3);

        public boolean onDoubleTapped(XImageView var1, MotionEvent var2);

        public void onLongPressed(XImageView var1, MotionEvent var2);

        public void onSetImageStart(XImageView var1);

        public void onSetImageFinished(XImageView var1, boolean var2, Rect var3);
    }

    private class XOnGestureListener
    extends GestureDetector.SimpleOnGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private XOnGestureListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            int x = (int)e.getX();
            int y = (int)e.getY();
            if (XImageView.this.mActionListener != null) {
                XImageView.this.mActionListener.onSingleTapped(XImageView.this, e, XImageView.this.mBitmapManager != null && XImageView.this.mBitmapManager.isTapOnImage(x, y));
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (XImageView.this.mBitmapManager == null) {
                return false;
            }
            boolean handled = false;
            if (XImageView.this.mActionListener != null) {
                handled = XImageView.this.mActionListener.onDoubleTapped(XImageView.this, e);
            }
            if (!handled) {
                int x = (int)e.getX();
                int y = (int)e.getY();
                XImageView.this.mBitmapManager.scaleToFitView(XImageView.this.mDoubleTapScaleType, x, y, true, 400L);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (XImageView.this.mActionListener != null) {
                XImageView.this.mActionListener.onLongPressed(XImageView.this, e);
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (XImageView.this.mBitmapManager == null) {
                return false;
            }
            int state = XImageView.this.mBitmapManager.offsetShowBitmap((int)(-distanceX), (int)(-distanceY));
            if ((state & 1) == 1 || (state & 2) == 2) {
                XImageView.this.interceptParentTouchEvent(false);
            }
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            XImageView.this.startFling(velocityX * 1.2f, velocityY * 1.2f);
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (XImageView.this.mBitmapManager == null) {
                return false;
            }
            float factor = detector.getScaleFactor();
            XImageView.this.mBitmapManager.scaleShowBitmap(detector.getFocusX(), detector.getFocusY(), factor);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (XImageView.this.mBitmapManager != null) {
                XImageView.this.mBitmapManager.updateSampleSize();
            }
        }
    }

    private class XGestureDetector
    extends GestureDetector {
        private ScaleGestureDetector mScaleDetector;

        public XGestureDetector(Context context) {
            super(context, (GestureDetector.OnGestureListener)XImageView.this.mGestureListener);
            this.mScaleDetector = null;
            this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)XImageView.this.mGestureListener);
        }

        public boolean onTouchEvent(MotionEvent event) {
            XImageView.this.stopFling();
            this.mScaleDetector.onTouchEvent(event);
            return super.onTouchEvent(event);
        }
    }

    public static enum TYPE_FIT {
        FIT_VIEW(0),
        FIT_IMAGE(1);

        final int mType;

        private TYPE_FIT(int t) {
            this.mType = t;
        }
    }
}

