/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.drawable.Drawable;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.ScatterValue;
import java.util.List;

public class ScatterDataSet
extends AbstractDataSet<ScatterValue> {
    private List<ScatterValue> scatterValues;
    private Drawable shape;
    private float drawOffsetX = 0.0f;
    private float drawOffsetY = 0.0f;
    private boolean autoWidth = true;

    public ScatterDataSet(List<ScatterValue> scatterValues) {
        this.scatterValues = scatterValues;
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (ScatterValue e : this.getVisiblePoints(viewport)) {
            this.calcViewportMinMax(e);
        }
    }

    private void calcViewportMinMax(ScatterValue e) {
        if (e.getValue() < this.mViewportYMin) {
            this.mViewportYMin = e.getValue();
        }
        if (e.getValue() > this.mViewportYMax) {
            this.mViewportYMax = e.getValue();
        }
    }

    @Override
    public int getEntryCount() {
        return this.getValues().size();
    }

    @Override
    public void setValues(List<ScatterValue> values) {
        this.scatterValues = values;
    }

    @Override
    public List<ScatterValue> getValues() {
        return this.scatterValues;
    }

    @Override
    public boolean addEntry(ScatterValue e) {
        this.calcViewportMinMax(e);
        return this.scatterValues.add(e);
    }

    @Override
    public boolean removeEntry(ScatterValue e) {
        return this.scatterValues.remove(e);
    }

    @Override
    public int getEntryIndex(ScatterValue e) {
        return this.scatterValues.indexOf(e);
    }

    @Override
    public ScatterValue getEntryForIndex(int index) {
        return this.scatterValues.get(index);
    }

    public void setShape(Drawable shape) {
        this.shape = shape;
    }

    public Drawable getShape() {
        return this.shape;
    }

    public float getDrawOffsetX() {
        return this.drawOffsetX;
    }

    public void setDrawOffsetX(float drawOffsetX) {
        this.drawOffsetX = drawOffsetX;
    }

    public float getDrawOffsetY() {
        return this.drawOffsetY;
    }

    public void setDrawOffsetY(float drawOffsetY) {
        this.drawOffsetY = drawOffsetY;
    }

    public void setAutoWidth(boolean autoWidth) {
        this.autoWidth = autoWidth;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }
}

