/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.CandlestickValue;
import java.util.ArrayList;
import java.util.List;

public class CandlestickDataSet
extends AbstractDataSet<CandlestickValue> {
    private List<CandlestickValue> candlestickValues;
    private boolean mAutoWidth = true;
    private float mCandleWidth = -1.0f;
    private int mIncreasingColor = -505013;
    private int mDecreasingColor = -14816421;
    private int mNeutralColor = -1;
    private float mViewportWidth = 1.0f;

    public CandlestickDataSet(List<CandlestickValue> candlestickValues) {
        this(candlestickValues, 25);
    }

    public CandlestickDataSet(List<CandlestickValue> candlestickValues, int axisDependency) {
        this.candlestickValues = candlestickValues;
        this.mViewport = new Viewport();
        this.calcMinMax();
        this.mDepsAxis = axisDependency;
    }

    @Override
    public void calcMinMax() {
        if (this.candlestickValues == null || this.candlestickValues.isEmpty()) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        for (CandlestickValue e : this.candlestickValues) {
            this.calcMinMaxY(e);
        }
        this.calcViewportY();
        if (this.mAxisLeft != null) {
            this.mAxisLeft.setYMax(this.mYMax);
            this.mAxisLeft.setYMin(this.mYMin);
        }
        if (this.mAxisRight != null) {
            this.mAxisRight.setYMax(this.mYMax);
            this.mAxisRight.setYMin(this.mYMin);
        }
    }

    private void calcViewportY() {
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (CandlestickValue e : this.getVisiblePoints(this.mViewport)) {
            this.calcViewportMinMaxX(e);
        }
    }

    private void calcViewportMinMaxX(CandlestickValue e) {
        if (e.getLow() < this.mViewportYMin) {
            this.mViewportYMin = e.getLow();
        }
        if (e.getHigh() > this.mViewportYMax) {
            this.mViewportYMax = e.getHigh();
        }
    }

    public int getVisibleCount(Viewport viewport) {
        return this.getVisiblePoints(viewport).size();
    }

    protected List<CandlestickValue> getVisiblePoints(Viewport viewport) {
        int from = (int)(viewport.left * (float)this.candlestickValues.size());
        int to = (int)(viewport.right * (float)this.candlestickValues.size());
        return this.candlestickValues.subList(from, to);
    }

    private void calcMinMaxY(CandlestickValue e) {
        if (e.getLow() < this.mYMin) {
            this.mYMin = e.getLow();
        }
        if (e.getHigh() > this.mYMax) {
            this.mYMax = e.getHigh();
        }
    }

    @Override
    public int getEntryCount() {
        return this.candlestickValues.size();
    }

    @Override
    public void setValues(List<CandlestickValue> values) {
        this.candlestickValues = values;
        this.calcMinMax();
    }

    @Override
    public List<CandlestickValue> getValues() {
        return this.candlestickValues;
    }

    @Override
    public boolean addEntry(CandlestickValue e) {
        if (e == null) {
            return false;
        }
        if (this.candlestickValues == null) {
            this.candlestickValues = new ArrayList<CandlestickValue>();
        }
        this.calcMinMaxY(e);
        return this.candlestickValues.add(e);
    }

    @Override
    public boolean removeEntry(CandlestickValue e) {
        if (e == null) {
            return false;
        }
        this.calcMinMaxY(e);
        return this.candlestickValues.remove(e);
    }

    @Override
    public int getEntryIndex(CandlestickValue e) {
        return this.candlestickValues.indexOf(e);
    }

    @Override
    public CandlestickValue getEntryForIndex(int index) {
        return this.candlestickValues.get(index);
    }

    public void onViewportChange(Rect content) {
        boolean needCalcCandleWidth = Float.compare(this.mViewport.width(), this.mViewportWidth) != 0;
        this.calcViewportY();
        if (needCalcCandleWidth) {
            this.mCandleWidth = content.width() / (this.getVisibleCount(this.mViewport) + 1);
        }
        this.mViewportWidth = this.mViewport.width();
    }

    public void setAutoWidth(boolean mAutoWidth) {
        this.mAutoWidth = mAutoWidth;
    }

    public boolean isAutoWidth() {
        return this.mAutoWidth;
    }

    public int getDecreasingColor() {
        return this.mDecreasingColor;
    }

    public void setDecreasingColor(int decreasingColor) {
        this.mDecreasingColor = decreasingColor;
    }

    public int getIncreasingColor() {
        return this.mIncreasingColor;
    }

    public void setIncreasingColor(int increasingColor) {
        this.mIncreasingColor = increasingColor;
    }

    public float getCandleWidth() {
        return this.mCandleWidth;
    }

    public int getNeutralColor() {
        return this.mNeutralColor;
    }
}

