/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.Chart;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.data.AbstractVisible;
import cn.jingzhuan.lib.chart.data.IDataSet;
import cn.jingzhuan.lib.chart.data.Value;
import java.util.List;

public abstract class AbstractDataSet<T extends Value>
extends AbstractVisible
implements IDataSet {
    protected float mYMax = -3.4028235E38f;
    protected float mYMin = Float.MAX_VALUE;
    protected float mXMax = -3.4028235E38f;
    protected float mXMin = Float.MAX_VALUE;
    protected float mViewportYMin = Float.MAX_VALUE;
    protected float mViewportYMax = -3.4028235E38f;
    private int mAxisDependency = 23;
    public Viewport mViewport;
    protected int mDepsAxis = 25;
    protected AxisY mAxisLeft;
    protected AxisY mAxisRight;
    private int mColor = -7829368;
    private boolean isHighlightedEnable = false;
    private boolean isHighlightedHorizontalEnable = false;

    public abstract void setValues(List<T> var1);

    public abstract List<T> getValues();

    public abstract boolean addEntry(T var1);

    public abstract boolean removeEntry(T var1);

    public abstract int getEntryIndex(T var1);

    public abstract T getEntryForIndex(int var1);

    public int getAxisDependency() {
        return this.mAxisDependency;
    }

    public void setAxisDependency(int mAxisDependency) {
        this.mAxisDependency = mAxisDependency;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    public float getViewportYMin() {
        return this.mViewportYMin;
    }

    public float getViewportYMax() {
        return this.mViewportYMax;
    }

    public AxisY getAxisLeft() {
        return this.mAxisLeft;
    }

    public AxisY getAxisRight() {
        return this.mAxisRight;
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int barColor) {
        this.mColor = barColor;
    }

    public void setHighlightedEnable(boolean highlightedEnable) {
        this.isHighlightedEnable = highlightedEnable;
    }

    public boolean isHighlightedEnable() {
        return this.isHighlightedEnable;
    }

    public void setHighlightedHorizontalEnable(boolean highlightedHorizontalEnable) {
        this.isHighlightedHorizontalEnable = highlightedHorizontalEnable;
    }

    public boolean isHighlightedHorizontalEnable() {
        return this.isHighlightedHorizontalEnable;
    }

    protected static void setAxisViewportY(AxisY axis, float min, float max) {
        if (axis != null) {
            axis.setYMin(min);
            axis.setYMax(max);
        }
    }

    public void setChart(Chart chart) {
        switch (this.mDepsAxis) {
            case 23: {
                this.mAxisLeft = chart.getAxisLeft();
                this.mAxisRight = null;
                break;
            }
            case 24: {
                this.mAxisLeft = null;
                this.mAxisRight = chart.getAxisRight();
                break;
            }
            case 25: {
                this.mAxisLeft = chart.getAxisLeft();
                this.mAxisRight = chart.getAxisRight();
            }
        }
        this.mViewport = chart.getCurrentViewport();
        this.calcMinMax();
    }
}

