/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import cn.jingzhuan.lib.chart.data.IDataSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChartData<T extends IDataSet> {
    private List<T> chartData;
    private float min = Float.MAX_VALUE;
    private float max = -3.4028235E38f;
    private int entryCount = 0;

    public ChartData() {
        this.chartData = new CopyOnWriteArrayList<T>();
    }

    public List<T> getDataSets() {
        if (this.chartData == null) {
            this.chartData = new CopyOnWriteArrayList<T>();
        }
        return this.chartData;
    }

    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        return this.getDataSets().add(e);
    }

    public boolean remove(T e) {
        if (e == null) {
            return false;
        }
        return this.getDataSets().remove(e);
    }

    public void calcMinMax() {
        for (IDataSet t : this.getDataSets()) {
            if (t.getYMax() > this.max) {
                this.max = t.getYMax();
            }
            if (t.getYMin() < this.min) {
                this.min = t.getYMin();
            }
            if (t.getEntryCount() <= this.entryCount) continue;
            this.entryCount = t.getEntryCount();
        }
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public int getEntryCount() {
        return this.entryCount;
    }
}

