/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2.data;

import android.graphics.drawable.Drawable;
import cn.jingzhuan.lib.chart.data.ScatterValue;
import cn.jingzhuan.lib.chart2.Viewport;
import cn.jingzhuan.lib.chart2.component.HasValueXOffset;
import cn.jingzhuan.lib.chart2.component.HasValueYOffset;
import cn.jingzhuan.lib.chart2.data.AbstractDataSet;
import cn.jingzhuan.lib.chart2.renderer.TextValueRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScatterDataSet
extends AbstractDataSet<ScatterValue>
implements HasValueYOffset,
HasValueXOffset {
    private List<ScatterValue> scatterValues;
    private Drawable shape;
    private float drawOffsetX = 0.0f;
    private float drawOffsetY = 0.0f;
    private boolean autoWidth = true;
    private List<TextValueRenderer> mTextValueRenderers;

    public ScatterDataSet(List<ScatterValue> scatterValues) {
        this.scatterValues = scatterValues;
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (ScatterValue e : this.getVisiblePoints(viewport)) {
            this.calcViewportMinMax(e);
        }
        float range = this.mViewportYMax - this.mViewportYMin;
        if ((float)Float.compare(this.getMinValueOffsetPercent(), 0.0f) > 0.0f) {
            this.mViewportYMin -= range * this.getMinValueOffsetPercent();
        }
        if ((float)Float.compare(this.getMaxValueOffsetPercent(), 0.0f) > 0.0f) {
            this.mViewportYMax += range * this.getMaxValueOffsetPercent();
        }
    }

    private void calcViewportMinMax(ScatterValue e) {
        if (e.getValue() < this.mViewportYMin) {
            this.mViewportYMin = e.getValue();
        }
        if (e.getValue() > this.mViewportYMax) {
            this.mViewportYMax = e.getValue();
        }
    }

    @Override
    public int getEntryCount() {
        if (this.getValues() == null) {
            return 0;
        }
        int entryCount = this.getValues().size();
        return this.getMinValueCount() > entryCount ? this.getMinValueCount() : entryCount;
    }

    @Override
    public void setValues(List<ScatterValue> values) {
        this.scatterValues = values;
    }

    @Override
    public List<ScatterValue> getValues() {
        return this.scatterValues;
    }

    @Override
    public boolean addEntry(ScatterValue e) {
        this.calcViewportMinMax(e);
        return this.scatterValues.add(e);
    }

    @Override
    public boolean removeEntry(ScatterValue e) {
        return this.scatterValues.remove(e);
    }

    @Override
    public int getEntryIndex(ScatterValue e) {
        return this.scatterValues.indexOf(e);
    }

    @Override
    public ScatterValue getEntryForIndex(int index) {
        return this.scatterValues.get(index);
    }

    public void setShape(Drawable shape) {
        this.shape = shape;
    }

    public Drawable getShape() {
        return this.shape;
    }

    public float getDrawOffsetX() {
        return this.drawOffsetX;
    }

    public void setDrawOffsetX(float drawOffsetX) {
        this.drawOffsetX = drawOffsetX;
    }

    public float getDrawOffsetY() {
        return this.drawOffsetY;
    }

    public void setDrawOffsetY(float drawOffsetY) {
        this.drawOffsetY = drawOffsetY;
    }

    public void setAutoWidth(boolean autoWidth) {
        this.autoWidth = autoWidth;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    @Override
    public float getMaxValueOffsetPercent() {
        return this.maxValueOffsetPercent;
    }

    @Override
    public float getMinValueOffsetPercent() {
        return this.minValueOffsetPercent;
    }

    @Override
    public void setMinValueOffsetPercent(float minValueOffsetPercent) {
        this.minValueOffsetPercent = minValueOffsetPercent;
    }

    @Override
    public void setMaxValueOffsetPercent(float maxValueOffsetPercent) {
        this.maxValueOffsetPercent = maxValueOffsetPercent;
    }

    @Override
    public float getStartXOffset() {
        return this.startXOffset;
    }

    @Override
    public void setStartXOffset(float startXOffset) {
        this.startXOffset = startXOffset;
    }

    @Override
    public float getEndXOffset() {
        return this.endXOffset;
    }

    @Override
    public void setEndXOffset(float endXOffset) {
        this.endXOffset = endXOffset;
    }

    public void addTextValueRenderer(TextValueRenderer textValueRenderer) {
        if (this.mTextValueRenderers == null) {
            this.mTextValueRenderers = Collections.synchronizedList(new ArrayList());
        }
        this.mTextValueRenderers.add(textValueRenderer);
    }

    public List<TextValueRenderer> getTextValueRenderers() {
        return this.mTextValueRenderers;
    }
}

