/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart2.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import cn.jingzhuan.lib.chart2.Viewport;
import java.lang.ref.WeakReference;

public abstract class BitmapCachedChart
extends View {
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    protected Viewport mCurrentViewport = new Viewport();
    protected Rect mContentRect = new Rect();

    public BitmapCachedChart(Context context) {
        super(context);
    }

    public BitmapCachedChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BitmapCachedChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public BitmapCachedChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public Rect getContentRect() {
        return this.mContentRect;
    }

    public Viewport getCurrentViewport() {
        return this.mCurrentViewport;
    }

    public Canvas getBitmapCanvas() {
        return this.mBitmapCanvas;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawAxis(canvas);
        int clipRestoreCount = canvas.save();
        canvas.clipRect(this.mContentRect);
        this.createBitmapCache(canvas);
        if (this.getBitmapCanvas() != null) {
            this.drawGridLine(this.getBitmapCanvas());
            this.render(this.getBitmapCanvas());
            canvas.drawBitmap(this.getDrawBitmap(), 0.0f, 0.0f, this.getRenderPaint());
        }
        canvas.restoreToCount(clipRestoreCount);
        this.drawLabels(canvas);
    }

    protected void createBitmapCache(Canvas canvas) {
        int width = this.getContentRect().width() + this.getContentRect().left;
        int height = this.getContentRect().height();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
    }

    protected Bitmap getDrawBitmap() {
        return (Bitmap)this.mDrawBitmap.get();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            if (this.mDrawBitmap.get() != null) {
                ((Bitmap)this.mDrawBitmap.get()).recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }

    public void releaseBitmap() {
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            if (this.mDrawBitmap.get() != null) {
                ((Bitmap)this.mDrawBitmap.get()).recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }

    protected abstract void drawAxis(Canvas var1);

    protected abstract void drawGridLine(Canvas var1);

    protected abstract void render(Canvas var1);

    protected abstract Paint getRenderPaint();

    protected abstract void drawLabels(Canvas var1);
}

