/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.base.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.data.LineData;
import cn.jingzhuan.lib.chart.data.LineDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import cn.jingzhuan.lib.chart.event.OnViewportChangeListener;
import cn.jingzhuan.lib.chart.renderer.AbstractDataRenderer;
import java.util.ArrayList;
import java.util.List;

public class LineRenderer
extends AbstractDataRenderer<LineDataSet> {
    private LineData lineData;
    private List<Path> shaderPaths;
    private List<Shader> shaderPathColors;
    private Path linePath = new Path();
    private Path shaderPath = new Path();

    public LineRenderer(final Chart chart) {
        super(chart);
        this.shaderPaths = new ArrayList<Path>();
        this.shaderPathColors = new ArrayList<Shader>();
        chart.setInternalViewportChangeListener(new OnViewportChangeListener(){

            @Override
            public void onViewportChange(Viewport viewport) {
                LineRenderer.this.mViewport.set(viewport);
                LineRenderer.this.calcDataSetMinMax();
            }
        });
        final Highlight highlight = new Highlight();
        chart.addOnTouchPointChangeListener(new Chart.OnTouchPointChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void touch(float x, float y) {
                if (chart.isHighlightDisable()) {
                    return;
                }
                Chart chart2 = chart;
                synchronized (chart2) {
                    for (LineDataSet line : LineRenderer.this.getDataSet()) {
                        if (!line.isHighlightedVerticalEnable() || line.getValues().isEmpty()) continue;
                        highlight.setTouchX(x);
                        highlight.setTouchY(y);
                        int offset = line.getStartIndexOffset();
                        int index = LineRenderer.this.getEntryIndexByCoordinate(x, y) - offset;
                        if (index < 0 || index >= line.getValues().size()) continue;
                        PointValue pointValue = line.getEntryForIndex(index);
                        float xPosition = pointValue.getX();
                        float yPosition = pointValue.getY();
                        if (!(xPosition >= 0.0f) || !(yPosition >= 0.0f)) continue;
                        highlight.setX(xPosition);
                        highlight.setY(yPosition);
                        highlight.setDataIndex(index);
                        chart.highlightValue(highlight);
                    }
                }
            }
        });
    }

    @Override
    public void renderHighlighted(Canvas canvas, @NonNull Highlight[] highlights) {
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        this.mRenderPaint.setColor(this.getHighlightColor());
        if (this.mHighlightedDashPathEffect != null) {
            this.mRenderPaint.setPathEffect((PathEffect)this.mHighlightedDashPathEffect);
        }
        for (Highlight highlight : highlights) {
            if (highlight == null) continue;
            canvas.drawLine(highlight.getX(), 0.0f, highlight.getX(), (float)this.mContentRect.bottom, this.mRenderPaint);
            for (LineDataSet lineDataSet : this.getDataSet()) {
                if (!lineDataSet.isHighlightedHorizontalEnable()) continue;
                canvas.drawLine(0.0f, highlight.getY(), (float)this.mContentRect.right, highlight.getY(), this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
    }

    @Override
    public void removeDataSet(LineDataSet dataSet) {
        this.lineData.remove(dataSet);
        this.calcDataSetMinMax();
    }

    @Override
    public void clearDataSet() {
        this.lineData.clear();
        this.calcDataSetMinMax();
    }

    @Override
    protected List<LineDataSet> getDataSet() {
        return this.lineData.getDataSets();
    }

    @Override
    public ChartData<LineDataSet> getChartData() {
        if (this.lineData == null) {
            this.lineData = new LineData();
        }
        return this.lineData;
    }

    @Override
    protected void renderDataSet(Canvas canvas, ChartData<LineDataSet> chartData) {
        for (LineDataSet dataSet : this.getDataSet()) {
            if (!dataSet.isVisible()) continue;
            this.drawDataSet(canvas, dataSet, chartData.getLeftMax(), chartData.getLeftMin(), chartData.getRightMax(), chartData.getRightMin());
        }
    }

    private void drawDataSet(Canvas canvas, LineDataSet lineDataSet, float lMax, float lMin, float rMax, float rMin) {
        int i;
        float max;
        float min;
        this.mRenderPaint.setStrokeWidth((float)lineDataSet.getLineThickness());
        this.mRenderPaint.setColor(lineDataSet.getColor());
        int valueCount = lineDataSet.getEntryCount();
        this.shaderPath.reset();
        this.shaderPaths.clear();
        this.shaderPathColors.clear();
        this.linePath.reset();
        boolean isFirst = true;
        switch (lineDataSet.getAxisDependency()) {
            case 24: {
                min = rMin;
                max = rMax;
                break;
            }
            default: {
                min = lMin;
                max = lMax;
            }
        }
        float count = lineDataSet.getVisibleRange(this.mViewport);
        float width = 0.0f;
        if (count > 0.0f) {
            width = (float)this.mContentRect.width() / count;
        }
        int offset = lineDataSet.getStartIndexOffset();
        float scale = 1.0f / this.mViewport.width();
        float step = (float)this.mContentRect.width() * scale / (float)valueCount;
        float startX = (float)this.mContentRect.left + step * 0.5f - this.mViewport.left * (float)this.mContentRect.width() * scale;
        PointValue prevValue = null;
        boolean shaderSplit = !Float.isNaN(lineDataSet.getShaderBaseValue()) && lineDataSet.getShaderBaseValue() < max && lineDataSet.getShaderBaseValue() > min;
        int lastIndex = 0;
        if (this.mChartAnimator.getPhaseX() > 0.0f) {
            lastIndex = (int)(Math.floor((float)lineDataSet.getValues().size() * this.mChartAnimator.getPhaseX()) - 1.0);
        }
        if (lastIndex >= valueCount) {
            lastIndex = valueCount - 1;
        }
        PointValue startPoint = null;
        int valuePhaseCount = (int)Math.floor((float)valueCount * this.mChartAnimator.getPhaseX());
        for (i = 0; i < valuePhaseCount && i < lineDataSet.getValues().size(); ++i) {
            PointValue point = lineDataSet.getEntryForIndex(i);
            if (Float.isNaN(point.getValue())) continue;
            float xPosition = startX + step * (float)(i + lineDataSet.getStartIndexOffset());
            float yPosition = (max - point.getValue()) / (max - min) * (float)this.mContentRect.height();
            point.setCoordinate(xPosition, yPosition);
            if (isFirst) {
                isFirst = false;
                this.linePath.moveTo(xPosition, yPosition);
            } else {
                this.linePath.lineTo(xPosition, yPosition);
            }
            if (!shaderSplit) continue;
            float baseValue = lineDataSet.getShaderBaseValue();
            float baseValueY = (float)this.mContentRect.height() / (max - min) * (max - baseValue);
            if (startPoint == null) {
                this.shaderPath.moveTo(xPosition, yPosition);
                startPoint = prevValue == null ? point : prevValue;
            } else {
                this.shaderPath.lineTo(xPosition, yPosition);
                if (prevValue.getValue() > lineDataSet.getShaderBaseValue()) {
                    if (point.getValue() <= lineDataSet.getShaderBaseValue()) {
                        this.shaderPath.lineTo(point.getX(), baseValueY);
                        this.shaderPath.lineTo(startPoint.getX(), baseValueY);
                        this.shaderPath.lineTo(startPoint.getX(), startPoint.getY());
                        this.shaderPath.close();
                        this.shaderPaths.add(new Path(this.shaderPath));
                        this.shaderPathColors.add(lineDataSet.getShaderTop());
                        this.shaderPath.reset();
                        startPoint = null;
                    }
                } else if (point.getValue() > lineDataSet.getShaderBaseValue()) {
                    this.shaderPath.lineTo(point.getX(), baseValueY);
                    this.shaderPath.lineTo(startPoint.getX(), baseValueY);
                    this.shaderPath.lineTo(startPoint.getX(), startPoint.getY());
                    this.shaderPath.close();
                    this.shaderPaths.add(new Path(this.shaderPath));
                    this.shaderPathColors.add(lineDataSet.getShaderBottom());
                    this.shaderPath.reset();
                    startPoint = null;
                }
            }
            prevValue = point;
            if (lastIndex != i) continue;
            this.shaderPath.lineTo(lineDataSet.getValues().get(lastIndex).getX(), baseValueY);
            this.shaderPath.lineTo(startPoint.getX(), baseValueY);
            this.shaderPath.lineTo(startPoint.getX(), startPoint.getY());
            this.shaderPath.close();
            this.shaderPaths.add(new Path(this.shaderPath));
            if (prevValue.getValue() > baseValue) {
                this.shaderPathColors.add(lineDataSet.getShaderTop());
            } else {
                this.shaderPathColors.add(lineDataSet.getShaderBottom());
            }
            this.shaderPath.reset();
            startPoint = null;
        }
        if (!shaderSplit) {
            if (i > 0 && lineDataSet.getShader() != null && lineDataSet.getValues().size() > 0) {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                if (this.shaderPath == null) {
                    this.shaderPath = new Path(this.linePath);
                } else {
                    this.shaderPath.set(this.linePath);
                }
                PointValue pointValue = lineDataSet.getEntryForIndex(i - 1);
                if (pointValue != null) {
                    this.shaderPath.lineTo(pointValue.getX(), (float)this.mContentRect.bottom);
                    this.shaderPath.lineTo((float)offset * width, (float)this.mContentRect.bottom);
                    this.shaderPath.lineTo((float)offset * width, lineDataSet.getValues().get(0).getY());
                    this.shaderPath.close();
                    this.mRenderPaint.setShader(lineDataSet.getShader());
                    canvas.drawPath(this.shaderPath, this.mRenderPaint);
                    this.mRenderPaint.setShader(null);
                    this.mRenderPaint.setStyle(Paint.Style.STROKE);
                }
            }
        } else {
            this.mRenderPaint.setStyle(Paint.Style.FILL);
            for (i = 0; i < this.shaderPaths.size(); ++i) {
                Path path = this.shaderPaths.get(i);
                Shader shader = this.shaderPathColors.get(i);
                this.mRenderPaint.setShader(shader);
                canvas.drawPath(path, this.mRenderPaint);
                this.mRenderPaint.setShader(null);
            }
            this.mRenderPaint.setStyle(Paint.Style.STROKE);
        }
        if (lineDataSet.isLineVisible()) {
            canvas.drawPath(this.linePath, this.mRenderPaint);
        }
    }
}

