/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.animation.ChartAnimator;
import cn.jingzhuan.lib.chart.base.BaseChart;
import cn.jingzhuan.lib.chart.base.Chart;
import cn.jingzhuan.lib.chart.component.Highlight;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.ChartData;
import cn.jingzhuan.lib.chart.renderer.Renderer;
import java.util.List;

public abstract class AbstractDataRenderer<T extends AbstractDataSet>
implements Renderer {
    protected Viewport mViewport;
    protected Rect mContentRect;
    protected Paint mRenderPaint;
    protected DashPathEffect mHighlightedDashPathEffect;
    private int mHighlightColor = -1;
    protected ChartAnimator mChartAnimator;

    public AbstractDataRenderer(Chart chart) {
        this.mViewport = chart.getCurrentViewport();
        this.mContentRect = chart.getContentRect();
        if (chart instanceof BaseChart) {
            this.mChartAnimator = ((BaseChart)chart).getChartAnimator();
        }
        this.getChartData().setChart(chart);
        this.mRenderPaint = new Paint(1);
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public final void renderer(Canvas canvas) {
        this.renderDataSet(canvas);
    }

    protected void renderDataSet(Canvas canvas) {
        this.renderDataSet(canvas, this.getChartData());
    }

    protected abstract void renderDataSet(Canvas var1, ChartData<T> var2);

    public abstract void renderHighlighted(Canvas var1, @NonNull Highlight[] var2);

    protected float getDrawX(float x) {
        return (float)this.mContentRect.left + (float)this.mContentRect.width() * (x - this.mViewport.left) / this.mViewport.width();
    }

    protected float getDrawY(float y) {
        return (float)this.mContentRect.bottom - (float)this.mContentRect.height() * (y - this.mViewport.top) / this.mViewport.height();
    }

    public void addDataSet(T dataSet) {
        if (dataSet == null) {
            return;
        }
        this.getChartData().add(dataSet);
        this.calcDataSetMinMax();
    }

    public abstract void removeDataSet(T var1);

    public abstract void clearDataSet();

    protected abstract List<T> getDataSet();

    public abstract ChartData<T> getChartData();

    public int getEntryIndexByCoordinate(float x, float y) {
        float valueCount = this.getChartData().getEntryCount();
        int index = (int)(((x - (float)this.mContentRect.left) * this.mViewport.width() / (float)this.mContentRect.width() + this.mViewport.left) * valueCount);
        if (index >= this.getChartData().getEntryCount()) {
            index = this.getChartData().getEntryCount() - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    protected void calcDataSetMinMax() {
        this.getChartData().calcMaxMin(this.mViewport, this.mContentRect);
    }

    public void setHighlightColor(int highlightColor) {
        this.mHighlightColor = highlightColor;
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    public void enableHighlightDashPathEffect(float[] intervals, float phase) {
        this.mHighlightedDashPathEffect = new DashPathEffect(intervals, phase);
    }

    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        if (maxVisibleEntryCount <= 0) {
            return;
        }
        this.getChartData().setMaxVisibleEntryCount(maxVisibleEntryCount);
    }

    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        if (minVisibleEntryCount <= 0) {
            return;
        }
        this.getChartData().setMinVisibleEntryCount(minVisibleEntryCount);
    }

    public void setDefaultVisibleEntryCount(int defaultVisibleEntryCount) {
        if (defaultVisibleEntryCount <= 0) {
            return;
        }
        this.getChartData().setDefaultVisibleEntryCount(defaultVisibleEntryCount);
    }

    public Paint getRenderPaint() {
        return this.mRenderPaint;
    }

    public ChartAnimator getChartAnimator() {
        return this.mChartAnimator;
    }

    public void setTypeface(Typeface tf) {
    }
}

