/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Shader;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.data.AbstractDataSet;
import cn.jingzhuan.lib.chart.data.PointValue;
import java.util.ArrayList;
import java.util.List;

public class LineDataSet
extends AbstractDataSet<PointValue> {
    private int mLineThickness = 2;
    protected List<PointValue> mPointValues;
    private int mForceValueCount = -1;
    private Shader shader;
    private Shader mShaderTop;
    private Shader mShaderBottom;
    private float mShaderBaseValue = Float.NaN;
    private boolean isLineVisible = true;

    public LineDataSet(List<PointValue> pointValues) {
        this(pointValues, 25);
    }

    public LineDataSet(List<PointValue> pointValues, int depsAxis) {
        this.mPointValues = pointValues;
        if (this.mPointValues == null) {
            this.mPointValues = new ArrayList<PointValue>();
        }
        this.setAxisDependency(depsAxis);
    }

    public int getLineThickness() {
        return this.mLineThickness;
    }

    public void setLineThickness(int mLineThickness) {
        this.mLineThickness = mLineThickness;
    }

    public List<PointValue> getLines() {
        return this.mPointValues;
    }

    @Override
    public int getEntryCount() {
        if (this.mPointValues == null) {
            return 0;
        }
        if (this.mForceValueCount > 0) {
            return this.mForceValueCount;
        }
        int entryCount = this.mPointValues.size();
        if (this.getMinValueCount() > entryCount) {
            entryCount = this.getMinValueCount();
        }
        return entryCount;
    }

    @Override
    public void calcMinMax(Viewport viewport) {
        if (this.mPointValues == null || this.mPointValues.isEmpty()) {
            return;
        }
        this.calcViewportY(viewport);
    }

    private void calcViewportY(Viewport viewport) {
        this.mViewportYMax = -3.4028235E38f;
        this.mViewportYMin = Float.MAX_VALUE;
        for (PointValue e : this.getVisiblePoints(viewport)) {
            this.calcViewportMinMax(e);
        }
    }

    @Override
    public void setValues(List<PointValue> values) {
        this.mPointValues = values;
    }

    @Override
    public List<PointValue> getValues() {
        return this.mPointValues;
    }

    private void calcViewportMinMax(PointValue e) {
        if (Float.isNaN(e.getValue()) || Float.isInfinite(e.getValue())) {
            return;
        }
        if (e.getValue() < this.mViewportYMin) {
            this.mViewportYMin = e.getValue();
        }
        if (e.getValue() > this.mViewportYMax) {
            this.mViewportYMax = e.getValue();
        }
    }

    @Override
    public boolean addEntry(PointValue e) {
        if (e == null) {
            return false;
        }
        if (this.mPointValues == null) {
            this.mPointValues = new ArrayList<PointValue>();
        }
        this.calcViewportMinMax(e);
        return this.mPointValues.add(e);
    }

    @Override
    public boolean removeEntry(PointValue e) {
        if (e == null) {
            return false;
        }
        if (this.mPointValues == null) {
            return false;
        }
        boolean removed = this.mPointValues.remove(e);
        return removed;
    }

    @Override
    public int getEntryIndex(PointValue e) {
        return this.mPointValues.indexOf(e);
    }

    @Override
    public PointValue getEntryForIndex(int index) {
        return this.mPointValues.get(index);
    }

    public void setForceValueCount(int mForceValueCount) {
        this.mForceValueCount = mForceValueCount;
    }

    public int getForceValueCount() {
        return this.mForceValueCount;
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }

    public float getShaderBaseValue() {
        return this.mShaderBaseValue;
    }

    public void setShaderBaseValue(float shaderBaseValue, Shader shaderTop, Shader shaderBottom) {
        this.mShaderBaseValue = shaderBaseValue;
        this.mShaderTop = shaderTop;
        this.mShaderBottom = shaderBottom;
    }

    public Shader getShaderTop() {
        return this.mShaderTop;
    }

    public Shader getShaderBottom() {
        return this.mShaderBottom;
    }

    public void setLineVisible(boolean lineVisible) {
        this.isLineVisible = lineVisible;
    }

    public boolean isLineVisible() {
        return this.isLineVisible;
    }
}

