/*
 * Decompiled with CFR 0.152.
 */
package cn.jingzhuan.lib.chart.data;

import android.graphics.Rect;
import cn.jingzhuan.lib.chart.Viewport;
import cn.jingzhuan.lib.chart.base.Chart;
import cn.jingzhuan.lib.chart.component.AxisY;
import cn.jingzhuan.lib.chart.data.IDataSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartData<T extends IDataSet> {
    private List<T> chartData;
    protected float leftMin = Float.MAX_VALUE;
    protected float leftMax = -3.4028235E38f;
    protected float rightMin = Float.MAX_VALUE;
    protected float rightMax = -3.4028235E38f;
    private int entryCount = 0;
    protected AxisY leftAxis;
    protected AxisY rightAxis;
    protected int maxVisibleEntryCount = 500;
    protected int minVisibleEntryCount = 20;
    protected int defaultVisibleEntryCount = -1;
    private int minValueCount = -1;

    public ChartData() {
        this.chartData = Collections.synchronizedList(new ArrayList());
    }

    public List<T> getDataSets() {
        if (this.chartData == null) {
            this.chartData = Collections.synchronizedList(new ArrayList());
        }
        return this.chartData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        e.setDefaultVisibleEntryCount(this.defaultVisibleEntryCount);
        e.setMinVisibleEntryCount(this.minVisibleEntryCount);
        e.setMaxVisibleEntryCount(this.maxVisibleEntryCount);
        ChartData chartData = this;
        synchronized (chartData) {
            return this.getDataSets().add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T e) {
        ChartData chartData = this;
        synchronized (chartData) {
            return e != null && this.getDataSets().remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ChartData chartData = this;
        synchronized (chartData) {
            this.getDataSets().clear();
        }
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
    }

    public void setMinMax() {
        if (this.leftAxis != null && this.leftMin != Float.MAX_VALUE) {
            this.leftAxis.setYMin(this.leftMin);
            this.leftAxis.setYMax(this.leftMax);
        }
        if (this.rightAxis != null && this.rightMin != Float.MAX_VALUE) {
            this.rightAxis.setYMin(this.rightMin);
            this.rightAxis.setYMax(this.rightMax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcMaxMin(Viewport viewport, Rect content) {
        this.leftMin = Float.MAX_VALUE;
        this.leftMax = -3.4028235E38f;
        this.rightMin = Float.MAX_VALUE;
        this.rightMax = -3.4028235E38f;
        this.entryCount = 0;
        if (!this.getDataSets().isEmpty()) {
            ChartData chartData = this;
            synchronized (chartData) {
                for (IDataSet t : this.getDataSets()) {
                    if (!t.isEnable()) continue;
                    t.calcMinMax(viewport);
                    if (t.getAxisDependency() == 25 || t.getAxisDependency() == 23) {
                        this.leftMax = Math.max(this.leftMax, t.getViewportYMax());
                        this.leftMin = Math.min(this.leftMin, t.getViewportYMin());
                    }
                    if (t.getAxisDependency() == 25 || t.getAxisDependency() == 24) {
                        this.rightMax = Math.max(this.rightMax, t.getViewportYMax());
                        this.rightMin = Math.min(this.rightMin, t.getViewportYMin());
                    }
                    if (t.getEntryCount() <= this.entryCount) continue;
                    this.entryCount = t.getEntryCount();
                }
            }
            this.setMinMax();
        }
    }

    public float getLeftMin() {
        return this.leftMin;
    }

    public float getRightMax() {
        return this.rightMax;
    }

    public float getRightMin() {
        return this.rightMin;
    }

    public float getLeftMax() {
        return this.leftMax;
    }

    public void setLeftMin(float leftMin) {
        this.leftMin = leftMin;
    }

    public void setLeftMax(float leftMax) {
        this.leftMax = leftMax;
    }

    public void setRightMin(float rightMin) {
        this.rightMin = rightMin;
    }

    public void setRightMax(float rightMax) {
        this.rightMax = rightMax;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setChart(Chart chart) {
        this.leftAxis = chart.getAxisLeft();
        this.rightAxis = chart.getAxisRight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxVisibleEntryCount(int maxVisibleEntryCount) {
        this.maxVisibleEntryCount = maxVisibleEntryCount;
        List<T> list = this.getDataSets();
        synchronized (list) {
            for (IDataSet t : this.getDataSets()) {
                t.setMaxVisibleEntryCount(maxVisibleEntryCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinVisibleEntryCount(int minVisibleEntryCount) {
        this.minVisibleEntryCount = minVisibleEntryCount;
        List<T> list = this.getDataSets();
        synchronized (list) {
            for (IDataSet t : this.getDataSets()) {
                t.setMinVisibleEntryCount(minVisibleEntryCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultVisibleEntryCount(int defaultVisibleEntryCount) {
        this.defaultVisibleEntryCount = defaultVisibleEntryCount;
        List<T> list = this.getDataSets();
        synchronized (list) {
            for (IDataSet t : this.getDataSets()) {
                t.setDefaultVisibleEntryCount(defaultVisibleEntryCount);
            }
        }
    }

    public int getMinValueCount() {
        return this.minValueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinValueCount(int minValueCount) {
        this.minValueCount = minValueCount;
        List<T> list = this.getDataSets();
        synchronized (list) {
            for (IDataSet t : this.getDataSets()) {
                t.setMinValueCount(minValueCount);
            }
        }
    }
}

