/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.methodcanary.lib;

import cn.hikyson.methodcanary.lib.MethodCanaryConfig;
import cn.hikyson.methodcanary.lib.MethodCanaryLogger;
import cn.hikyson.methodcanary.lib.MethodCanaryMethodRecord;
import cn.hikyson.methodcanary.lib.MethodCanaryOnGetRecordsCallback;
import cn.hikyson.methodcanary.lib.MethodCanaryTaskQueue;
import cn.hikyson.methodcanary.lib.MethodEvent;
import cn.hikyson.methodcanary.lib.ThreadInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MethodCanaryForCommon {
    private MethodCanaryTaskQueue mTaskQueue;
    private HashMap<String, Long> mMethodCanarySessionInfos = new HashMap();
    private MethodCanaryMethodRecord methodCanaryMethodRecord;

    MethodCanaryForCommon() {
        this.mTaskQueue = new MethodCanaryTaskQueue("AndroidGodEye-MethodCanary-Record");
        this.methodCanaryMethodRecord = new MethodCanaryMethodRecord(this.mTaskQueue);
    }

    synchronized void start(String sessionTag) {
        long startMillis = System.currentTimeMillis();
        MethodCanaryLogger.log("[MethodCanary] start session:" + sessionTag + ", startMillis:" + startMillis);
        if (this.mMethodCanarySessionInfos.containsKey(sessionTag)) {
            throw new IllegalStateException("can not start same session.");
        }
        this.mMethodCanarySessionInfos.put(sessionTag, startMillis);
        this.mTaskQueue.start();
        this.methodCanaryMethodRecord.startRecordRightNow();
    }

    synchronized void stop(final String sessionTag, MethodCanaryConfig methodCanaryConfig, final MethodCanaryOnGetRecordsCallback methodCanaryOnGetRecordsCallback) {
        final long stopMillis = System.currentTimeMillis();
        MethodCanaryLogger.log("[MethodCanary] stop session:" + sessionTag + ", stopMillis:" + stopMillis);
        final Long startMillis = this.mMethodCanarySessionInfos.remove(sessionTag);
        if (startMillis == null || startMillis <= 0L) {
            throw new IllegalStateException("can not stop because session not started.");
        }
        this.methodCanaryMethodRecord.getRecords(startMillis, stopMillis, methodCanaryConfig, new MethodCanaryMethodRecord.OnGetRecordsCallback(){

            @Override
            public void onGetRecords(Map<ThreadInfo, List<MethodEvent>> methodEventMap) {
                if (methodCanaryOnGetRecordsCallback != null) {
                    methodCanaryOnGetRecordsCallback.onGetRecords(sessionTag, startMillis, stopMillis, methodEventMap);
                }
                MethodCanaryLogger.log("[MethodCanary] on get records for session:" + sessionTag + ", startMillis:" + startMillis + ", stopMillis:" + stopMillis + ", thread count:" + methodEventMap.size());
            }
        });
        if (this.mMethodCanarySessionInfos.isEmpty()) {
            this.methodCanaryMethodRecord.stopRecordRightNow();
            MethodCanaryLogger.log("[MethodCanary] stopping all.");
        }
    }

    synchronized boolean isRunning(String sessionTag) {
        return this.mMethodCanarySessionInfos.containsKey(sessionTag);
    }

    void onMethodEnter(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        this.methodCanaryMethodRecord.onMethodEnter(accessFlag, className, methodName, desc, type, objs);
    }

    void onMethodExit(int accessFlag, String className, String methodName, String desc, int type, Object[] objs) {
        this.methodCanaryMethodRecord.onMethodExit(accessFlag, className, methodName, desc, type, objs);
    }

    MethodCanaryMethodRecord getMethodCanaryMethodRecord() {
        return this.methodCanaryMethodRecord;
    }

    void setMethodCanaryMethodRecord(MethodCanaryMethodRecord methodCanaryMethodRecord) {
        this.methodCanaryMethodRecord = methodCanaryMethodRecord;
    }
}

