/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.android.godeye.okhttp;

import cn.hikyson.android.godeye.okhttp.HttpContent;
import cn.hikyson.android.godeye.okhttp.HttpContentTimeMapping;
import cn.hikyson.godeye.core.GodEyeHelper;
import cn.hikyson.godeye.core.exceptions.UninstallException;
import cn.hikyson.godeye.core.internal.modules.network.NetworkInfo;
import cn.hikyson.godeye.core.internal.modules.network.NetworkTime;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

class OkNetworkEventListener
extends EventListener {
    private NetworkInfo<HttpContent> mNetworkInfo;
    private long mCallStartTimeMillis;
    private long mDnsStartTimeMillis;
    private long mConnectionStartTimeMillis;
    private long mRequestHeadersStartTimeMillis;
    private long mRequestBodyStartTimeMillis;
    private long mResponseHeadersStartTimeMillis;
    private long mResponseBodyStartTimeMillis;
    private HttpContentTimeMapping mHttpContentTimeMapping;

    OkNetworkEventListener(HttpContentTimeMapping httpContentTimeMapping) {
        this.mHttpContentTimeMapping = httpContentTimeMapping;
        this.mNetworkInfo = new NetworkInfo();
        this.mNetworkInfo.networkTime = new NetworkTime();
        this.mNetworkInfo.extraInfo = new HashMap();
    }

    public void callStart(Call call) {
        super.callStart(call);
        this.mCallStartTimeMillis = System.currentTimeMillis();
        this.mNetworkInfo.summary = call.request().method() + " " + call.request().url();
    }

    public void dnsStart(Call call, String domainName) {
        super.dnsStart(call, domainName);
        this.mDnsStartTimeMillis = System.currentTimeMillis();
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("DnsTime", System.currentTimeMillis() - this.mDnsStartTimeMillis);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.mConnectionStartTimeMillis = System.currentTimeMillis();
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("ConnectTime", System.currentTimeMillis() - this.mConnectionStartTimeMillis);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("ConnectTime", System.currentTimeMillis() - this.mConnectionStartTimeMillis);
    }

    public void connectionAcquired(Call call, Connection connection) {
        InetAddress remoteAddress;
        super.connectionAcquired(call, connection);
        Handshake handshake = connection.handshake();
        String cipherSuite = "";
        String tlsVersion = "";
        if (handshake != null) {
            cipherSuite = handshake.cipherSuite().javaName();
            tlsVersion = handshake.tlsVersion().javaName();
        }
        Socket socket = connection.socket();
        int localPort = socket.getLocalPort();
        int remotePort = socket.getPort();
        String localIp = "";
        String remoteIp = "";
        InetAddress localAddress = socket.getLocalAddress();
        if (localAddress != null) {
            localIp = localAddress.getHostAddress();
        }
        if ((remoteAddress = socket.getInetAddress()) != null) {
            remoteIp = remoteAddress.getHostAddress();
        }
        this.mNetworkInfo.extraInfo.put("cipherSuite", cipherSuite);
        this.mNetworkInfo.extraInfo.put("tlsVersion", tlsVersion);
        this.mNetworkInfo.extraInfo.put("localIp", localIp);
        this.mNetworkInfo.extraInfo.put("localPort", localPort);
        this.mNetworkInfo.extraInfo.put("remoteIp", remoteIp);
        this.mNetworkInfo.extraInfo.put("remotePort", remotePort);
    }

    public void requestHeadersStart(Call call) {
        super.requestHeadersStart(call);
        this.mRequestHeadersStartTimeMillis = System.currentTimeMillis();
    }

    public void requestHeadersEnd(Call call, Request request) {
        super.requestHeadersEnd(call, request);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("RequestHeadersTime", System.currentTimeMillis() - this.mRequestHeadersStartTimeMillis);
    }

    public void requestBodyStart(Call call) {
        super.requestBodyStart(call);
        this.mRequestBodyStartTimeMillis = System.currentTimeMillis();
    }

    public void requestBodyEnd(Call call, long byteCount) {
        super.requestBodyEnd(call, byteCount);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("RequestBodyTime", System.currentTimeMillis() - this.mRequestBodyStartTimeMillis);
    }

    public void responseHeadersStart(Call call) {
        super.responseHeadersStart(call);
        this.mResponseHeadersStartTimeMillis = System.currentTimeMillis();
    }

    public void responseHeadersEnd(Call call, Response response) {
        super.responseHeadersEnd(call, response);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("ResponseHeadersTime", System.currentTimeMillis() - this.mResponseHeadersStartTimeMillis);
    }

    public void responseBodyStart(Call call) {
        super.responseBodyStart(call);
        this.mResponseBodyStartTimeMillis = System.currentTimeMillis();
    }

    public void responseBodyEnd(Call call, long byteCount) {
        super.responseBodyEnd(call, byteCount);
        this.mNetworkInfo.networkTime.networkTimeMillisMap.put("ResponseBodyTime", System.currentTimeMillis() - this.mResponseBodyStartTimeMillis);
    }

    public void callEnd(Call call) {
        super.callEnd(call);
        this.mNetworkInfo.networkTime.totalTimeMillis = System.currentTimeMillis() - this.mCallStartTimeMillis;
        this.mNetworkInfo.networkContent = this.mHttpContentTimeMapping.removeAndGetRecord(call);
        if (this.mNetworkInfo.networkContent != null) {
            if (((HttpContent)this.mNetworkInfo.networkContent).httpResponse != null) {
                this.mNetworkInfo.isSuccessful = OkNetworkEventListener.isSuccessful(((HttpContent)this.mNetworkInfo.networkContent).httpResponse.code);
            }
            if (((HttpContent)this.mNetworkInfo.networkContent).httpResponse != null) {
                this.mNetworkInfo.message = ((HttpContent)this.mNetworkInfo.networkContent).httpResponse.message;
            }
        }
        try {
            GodEyeHelper.onNetworkEnd(this.mNetworkInfo);
        }
        catch (UninstallException e) {
            e.printStackTrace();
        }
    }

    public void callFailed(Call call, IOException ioe) {
        super.callFailed(call, ioe);
        this.mNetworkInfo.networkTime.totalTimeMillis = System.currentTimeMillis() - this.mCallStartTimeMillis;
        this.mNetworkInfo.isSuccessful = false;
        this.mNetworkInfo.message = String.valueOf(ioe);
        this.mNetworkInfo.networkContent = this.mHttpContentTimeMapping.removeAndGetRecord(call);
        try {
            GodEyeHelper.onNetworkEnd(this.mNetworkInfo);
        }
        catch (UninstallException e) {
            e.printStackTrace();
        }
    }

    private static boolean isSuccessful(int code) {
        return code >= 200 && code < 300;
    }
}

