/*
 * Decompiled with CFR 0.152.
 */
package cn.hikyson.android.godeye.okhttp;

import cn.hikyson.android.godeye.okhttp.HttpContent;
import cn.hikyson.android.godeye.okhttp.HttpContentTimeMapping;
import cn.hikyson.godeye.core.utils.IoUtil;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;

class OkHttpNetworkContentInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    HttpContentTimeMapping mHttpContentTimeMapping;

    OkHttpNetworkContentInterceptor(HttpContentTimeMapping httpContentTimeMapping) {
        this.mHttpContentTimeMapping = httpContentTimeMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection = chain.connection();
        HttpContent httpContent = new HttpContent();
        this.mHttpContentTimeMapping.addRecord(chain.call(), httpContent);
        httpContent.httpRequest.method = request.method();
        httpContent.httpRequest.url = String.valueOf(request.url());
        httpContent.httpRequest.protocol = connection != null ? String.valueOf(connection.protocol()) : "NULL";
        httpContent.httpRequest.headers = new HashMap<String, String>();
        Headers headers = request.headers();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            httpContent.httpRequest.headers.put(headers.name(i), headers.value(i));
        }
        if (!hasRequestBody) {
            httpContent.httpRequest.payload = "(No request body)";
        } else if (OkHttpNetworkContentInterceptor.bodyHasUnknownEncoding(request.headers())) {
            httpContent.httpRequest.payload = "(Unknown encoding request body)";
        } else if (requestBody.isDuplex()) {
            httpContent.httpRequest.payload = "(duplex request body, Maybe HTTP2)";
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = null;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (charset == null) {
                charset = UTF8;
            }
            httpContent.httpRequest.payload = OkHttpNetworkContentInterceptor.isPlaintext(buffer) ? buffer.readString(charset) + "\n(" + requestBody.contentLength() + "-byte request body)" : "(binary " + requestBody.contentLength() + "-byte request body)";
        }
        Response response = chain.proceed(request);
        ResponseBody responseBody = response.body();
        long contentLength = responseBody.contentLength();
        httpContent.httpResponse.protocol = String.valueOf(response.protocol());
        httpContent.httpResponse.code = response.code();
        httpContent.httpResponse.message = response.message();
        httpContent.httpResponse.headers = new HashMap<String, String>();
        Headers responseHeaders = response.headers();
        int count2 = responseHeaders.size();
        for (int i = 0; i < count2; ++i) {
            httpContent.httpResponse.headers.put(responseHeaders.name(i), responseHeaders.value(i));
        }
        if (!HttpHeaders.hasBody((Response)response)) {
            httpContent.httpResponse.payload = "(No response body)";
        } else if (OkHttpNetworkContentInterceptor.bodyHasUnknownEncoding(responseHeaders)) {
            httpContent.httpResponse.payload = "(Unknown encoding response body)";
        } else {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Long gzippedLength = null;
            if ("gzip".equalsIgnoreCase(responseHeaders.get("Content-Encoding"))) {
                gzippedLength = buffer.size();
                GzipSource gzippedResponseBody = null;
                try {
                    gzippedResponseBody = new GzipSource((Source)buffer.clone());
                    buffer = new Buffer();
                    buffer.writeAll((Source)gzippedResponseBody);
                }
                catch (Throwable throwable) {
                    IoUtil.closeSilently(gzippedResponseBody);
                    throw throwable;
                }
                IoUtil.closeSilently((Closeable)gzippedResponseBody);
            }
            Charset charset = null;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (charset == null) {
                charset = UTF8;
            }
            if (!OkHttpNetworkContentInterceptor.isPlaintext(buffer)) {
                httpContent.httpResponse.payload = "(binary " + buffer.size() + "-byte response body)";
                return response;
            }
            if (contentLength != 0L) {
                httpContent.httpResponse.payload = buffer.clone().readString(charset);
            }
            httpContent.httpResponse.payload = gzippedLength != null ? httpContent.httpResponse.payload + "\n(" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte response body)" : httpContent.httpResponse.payload + "\n(" + buffer.size() + "-byte response body)";
        }
        return response;
    }

    private static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private static boolean bodyHasUnknownEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip");
    }
}

