/*
 * Decompiled with CFR 0.152.
 */
package com.dxjia.library;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.dxjia.library.R;

public class ImageTextButton
extends RelativeLayout {
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_TOP = 1;
    public static final int ICON_POSITION_RIGHT = 2;
    public static final int ICON_POSITION_BOTTOM = 3;
    private ImageView mIconView;
    private TextView mBtnTextView;
    private LinearLayout mArea;
    private int mIconPositon = 0;

    public ImageTextButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public ImageTextButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ImageTextButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ImageTextButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ImageTextButton);
        this.mIconPositon = typedArray.getInt(R.styleable.ImageTextButton_itb_icon_position, 0);
        View rootView = this.initLayout(context);
        this.mArea = this.getArea(rootView);
        this.mIconView = this.getIconView((View)this.mArea);
        this.mBtnTextView = this.getBtnTextView((View)this.mArea);
        if (this.mArea == null || this.mIconView == null || this.mBtnTextView == null) {
            return;
        }
        this.mArea.setGravity(13);
        this.initPadding(typedArray);
        this.initBackground(typedArray);
        this.initTextView(typedArray, this.mBtnTextView);
        this.initIcon(typedArray, this.mIconView);
        typedArray.recycle();
    }

    private View initLayout(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        switch (this.mIconPositon) {
            case 0: {
                return inflater.inflate(R.layout.layout_image_text_button_left, (ViewGroup)this);
            }
            case 1: {
                return inflater.inflate(R.layout.layout_image_text_button_top, (ViewGroup)this);
            }
            case 2: {
                return inflater.inflate(R.layout.layout_image_text_button_right, (ViewGroup)this);
            }
            case 3: {
                return inflater.inflate(R.layout.layout_image_text_button_bottom, (ViewGroup)this);
            }
        }
        return inflater.inflate(R.layout.layout_image_text_button_left, (ViewGroup)this);
    }

    private LinearLayout getArea(View rootView) {
        if (rootView != null) {
            return (LinearLayout)rootView.findViewById(R.id.area);
        }
        return null;
    }

    private ImageView getIconView(View parentView) {
        if (parentView != null) {
            return (ImageView)parentView.findViewById(R.id.icon);
        }
        return null;
    }

    private TextView getBtnTextView(View parentView) {
        if (parentView != null) {
            return (TextView)parentView.findViewById(R.id.button_text);
        }
        return null;
    }

    private int px2dip(float pxValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private void initBackground(TypedArray typedArray) {
        int radius = typedArray.getDimensionPixelOffset(R.styleable.ImageTextButton_itb_radius, this.getResources().getDimensionPixelOffset(R.dimen.default_radius));
        int btnNormalBgColor = typedArray.getColor(R.styleable.ImageTextButton_itb_bg, this.getResources().getColor(R.color.default_bg));
        int btnPressedBgColor = typedArray.getColor(R.styleable.ImageTextButton_itb_bg_pressed, -1);
        if (btnPressedBgColor == -1) {
            int alpha = Color.alpha((int)btnNormalBgColor);
            int red = Color.red((int)btnNormalBgColor);
            int green = Color.green((int)btnNormalBgColor);
            int blue = Color.blue((int)btnNormalBgColor);
            btnPressedBgColor = alpha < 255 ? Color.argb((int)255, (int)red, (int)green, (int)blue) : Color.argb((int)144, (int)red, (int)green, (int)blue);
        }
        int btnDisabledBgColor = typedArray.getColor(R.styleable.ImageTextButton_itb_bg_disabled, this.getResources().getColor(R.color.default_bg_disabled));
        GradientDrawable normalShape = new GradientDrawable();
        normalShape.setColor(btnNormalBgColor);
        if (radius > 0) {
            normalShape.setCornerRadius((float)radius);
        }
        GradientDrawable pressedShape = new GradientDrawable();
        pressedShape.setColor(btnPressedBgColor);
        if (radius > 0) {
            pressedShape.setCornerRadius((float)radius);
        }
        GradientDrawable disabledShape = new GradientDrawable();
        disabledShape.setColor(btnDisabledBgColor);
        if (radius > 0) {
            disabledShape.setCornerRadius((float)radius);
        }
        StateListDrawable bg = new StateListDrawable();
        bg.addState(new int[]{16842919}, (Drawable)pressedShape);
        bg.addState(new int[]{16842910}, (Drawable)normalShape);
        this.setBackground((Drawable)bg);
        this.setClickable(true);
    }

    private void initPadding(TypedArray typedArray) {
        int padding = typedArray.getDimensionPixelOffset(R.styleable.ImageTextButton_itb_padding, this.getResources().getDimensionPixelOffset(R.dimen.default_padding));
        if (padding > 0) {
            this.setPadding(padding, padding, padding, padding);
        }
    }

    private void initTextView(TypedArray typedArray, TextView textView) {
        String btnText = typedArray.getString(R.styleable.ImageTextButton_itb_text);
        int btnTextSize = typedArray.getDimensionPixelSize(R.styleable.ImageTextButton_itb_text_size, this.getResources().getDimensionPixelSize(R.dimen.default_text_size));
        if (TextUtils.isEmpty((CharSequence)btnText)) {
            textView.setVisibility(8);
        } else {
            int btnTextColor = typedArray.getColor(R.styleable.ImageTextButton_itb_text_color, this.getResources().getColor(R.color.default_text_color));
            textView.setTextColor(btnTextColor);
            textView.setTextSize((float)this.px2dip(btnTextSize));
            int marggin = typedArray.getDimensionPixelOffset(R.styleable.ImageTextButton_itb_icon_text_marggin, this.getResources().getDimensionPixelOffset(R.dimen.default_text_margin));
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)textView.getLayoutParams();
            switch (this.mIconPositon) {
                case 0: {
                    params.setMargins(marggin, 0, 0, 0);
                    break;
                }
                case 1: {
                    params.setMargins(0, marggin, 0, 0);
                    break;
                }
                case 2: {
                    params.setMargins(0, 0, marggin, 0);
                    break;
                }
                case 3: {
                    params.setMargins(0, 0, 0, marggin);
                    break;
                }
                default: {
                    params.setMargins(marggin, 0, 0, 0);
                }
            }
            textView.setLayoutParams((ViewGroup.LayoutParams)params);
            textView.setText((CharSequence)btnText);
        }
    }

    private void initIcon(TypedArray typedArray, ImageView iconView) {
        Drawable icon = typedArray.getDrawable(R.styleable.ImageTextButton_itb_icon);
        if (icon != null) {
            int iconSize = typedArray.getDimensionPixelSize(R.styleable.ImageTextButton_itb_icon_size, this.getResources().getDimensionPixelOffset(R.dimen.default_icon_width));
            ViewGroup.LayoutParams params = iconView.getLayoutParams();
            params.height = iconSize;
            params.width = iconSize;
            iconView.setLayoutParams(params);
            iconView.setImageDrawable(icon);
        } else {
            iconView.setVisibility(8);
        }
    }

    public ImageView getIconView() {
        return this.mIconView;
    }

    public TextView getButtonTextView() {
        return this.mBtnTextView;
    }

    public void setIcon(int resId) {
        if (this.mIconView != null) {
            this.mIconView.setImageResource(resId);
        }
    }

    public void setIcon(Drawable drawable) {
        if (this.mIconView != null) {
            this.mIconView.setImageDrawable(drawable);
        }
    }

    public void setButtonText(String text) {
        if (this.mBtnTextView != null) {
            this.mBtnTextView.setText((CharSequence)text);
        }
    }

    public void changeBackground(Drawable drawable) {
        this.setBackground(drawable);
    }
}

