/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatDialog;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import cn.com.lasong.widget.R;
import cn.com.lasong.widget.dialog.TopSheetBehavior;
import cn.com.lasong.widget.utils.ViewHelper;

public class TopSheetDialog
extends AppCompatDialog {
    private TopSheetBehavior<FrameLayout> behavior;
    private FrameLayout container;
    boolean dismissWithAnimation;
    boolean cancelable = true;
    private boolean canceledOnTouchOutside = true;
    private boolean canceledOnTouchOutsideSet;
    private boolean consumeTouch = true;
    @NonNull
    private TopSheetBehavior.TopSheetCallback topSheetCallback = new TopSheetBehavior.TopSheetCallback(){

        @Override
        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            Log.d((String)"Test", (String)("onStateChanged : " + newState));
            if (newState == 5 || newState == 4) {
                TopSheetDialog.this.cancel();
            }
        }

        @Override
        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
        }
    };

    public TopSheetDialog(@NonNull Context context) {
        this(context, 0);
    }

    public TopSheetDialog(@NonNull Context context, @StyleRes int theme) {
        super(context, TopSheetDialog.getThemeResId(context, theme));
        this.supportRequestWindowFeature(1);
    }

    protected TopSheetDialog(@NonNull Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.supportRequestWindowFeature(1);
        this.cancelable = cancelable;
    }

    public void setContentView(@LayoutRes int layoutResId) {
        super.setContentView(this.wrapInTopSheet(layoutResId, null, null));
        this.onContentViewCreated((View)this.container);
    }

    public void setContentView(View view) {
        super.setContentView(this.wrapInTopSheet(0, view, null));
        this.onContentViewCreated((View)this.container);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(this.wrapInTopSheet(0, view, params));
        this.onContentViewCreated((View)this.container);
    }

    protected void onContentViewCreated(View parent) {
    }

    protected final FrameLayout getContainer() {
        return this.container;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        if (window != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
            }
            window.setLayout(-1, -1);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean ret = super.onTouchEvent(event);
        if (null != this.container && !this.consumeTouch) {
            FrameLayout bottomSheet = (FrameLayout)this.container.findViewById(R.id.design_top_sheet);
            if (null != bottomSheet) {
                ret &= ViewHelper.isPointInChildBounds((ViewGroup)this.container, (View)bottomSheet, (int)event.getX(), (int)event.getY());
            }
            if (!ret && this.getRealContext() instanceof Activity) {
                Activity activity = (Activity)this.getRealContext();
                MotionEvent e = MotionEvent.obtain((MotionEvent)event);
                e.offsetLocation(0.0f, (float)ViewHelper.getStatusBarHeight(this.getContext()));
                activity.dispatchTouchEvent(e);
                e.recycle();
            }
        }
        return ret;
    }

    protected Context getRealContext() {
        Context context = this.getContext();
        if (context instanceof ContextWrapper) {
            return ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        if (this.cancelable != cancelable) {
            this.cancelable = cancelable;
            if (this.behavior != null) {
                this.behavior.setHideable(cancelable);
            }
        }
    }

    public void setConsumeTouch(boolean consumeTouch) {
        this.consumeTouch = consumeTouch;
    }

    protected void onStart() {
        super.onStart();
        if (this.behavior != null && this.behavior.getState() == 5) {
            this.behavior.setState(4);
        }
    }

    public void cancel() {
        TopSheetBehavior<FrameLayout> behavior = this.getBehavior();
        if (!this.dismissWithAnimation || behavior.getState() == 5 || behavior.getState() == 4) {
            super.cancel();
        } else {
            behavior.setState(5);
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        if (cancel && !this.cancelable) {
            this.cancelable = true;
        }
        this.canceledOnTouchOutside = cancel;
        this.canceledOnTouchOutsideSet = true;
    }

    @NonNull
    public TopSheetBehavior<FrameLayout> getBehavior() {
        if (this.behavior == null) {
            this.ensureContainerAndBehavior();
        }
        return this.behavior;
    }

    public void setDismissWithAnimation(boolean dismissWithAnimation) {
        this.dismissWithAnimation = dismissWithAnimation;
    }

    public boolean getDismissWithAnimation() {
        return this.dismissWithAnimation;
    }

    private FrameLayout ensureContainerAndBehavior() {
        if (this.container == null) {
            this.container = (FrameLayout)View.inflate((Context)this.getContext(), (int)R.layout.design_top_sheet_dialog, null);
            FrameLayout bottomSheet = (FrameLayout)this.container.findViewById(R.id.design_top_sheet);
            this.behavior = TopSheetBehavior.from(bottomSheet);
            this.behavior.addTopSheetCallback(this.topSheetCallback);
            this.behavior.setHideable(this.cancelable);
        }
        return this.container;
    }

    private View wrapInTopSheet(int layoutResId, @Nullable View view, @Nullable ViewGroup.LayoutParams params) {
        this.ensureContainerAndBehavior();
        CoordinatorLayout coordinator = (CoordinatorLayout)this.container.findViewById(R.id.coordinator);
        if (layoutResId != 0 && view == null) {
            view = this.getLayoutInflater().inflate(layoutResId, (ViewGroup)coordinator, false);
        }
        FrameLayout bottomSheet = (FrameLayout)this.container.findViewById(R.id.design_top_sheet);
        if (params == null) {
            bottomSheet.addView(view);
        } else {
            bottomSheet.addView(view, params);
        }
        coordinator.findViewById(R.id.touch_outside).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (TopSheetDialog.this.cancelable && TopSheetDialog.this.isShowing() && TopSheetDialog.this.shouldWindowCloseOnTouchOutside()) {
                    TopSheetDialog.this.cancel();
                    return true;
                }
                return TopSheetDialog.this.consumeTouch;
            }
        });
        ViewCompat.setAccessibilityDelegate((View)bottomSheet, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                if (TopSheetDialog.this.cancelable) {
                    info.addAction(0x100000);
                    info.setDismissable(true);
                } else {
                    info.setDismissable(false);
                }
            }

            public boolean performAccessibilityAction(View host, int action, Bundle args) {
                if (action == 0x100000 && TopSheetDialog.this.cancelable) {
                    TopSheetDialog.this.cancel();
                    return true;
                }
                return super.performAccessibilityAction(host, action, args);
            }
        });
        bottomSheet.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return true;
            }
        });
        return this.container;
    }

    boolean shouldWindowCloseOnTouchOutside() {
        if (!this.canceledOnTouchOutsideSet) {
            TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843611});
            this.canceledOnTouchOutside = a.getBoolean(0, true);
            a.recycle();
            this.canceledOnTouchOutsideSet = true;
        }
        return this.canceledOnTouchOutside;
    }

    private static int getThemeResId(@NonNull Context context, int themeId) {
        if (themeId == 0) {
            themeId = R.style.Theme_Design_Light_TopSheetDialog;
        }
        return themeId;
    }

    void removeDefaultCallback() {
        this.behavior.removeTopSheetCallback(this.topSheetCallback);
    }
}

