/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.touch;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MoveView
extends RelativeLayout {
    public static final int SIDE_NONE = 0;
    public static final int SIDE_BORDER = 1;
    public static final int SIDE_CENTER_X = 3;
    private int mSide = 3;
    protected int mTouchSlop;
    protected Rect mContainerRect = new Rect();
    protected Rect mContainerPadding = new Rect();
    protected boolean mAttachWindow = false;
    protected float mTouchLastX;
    protected float mTouchLastY;
    protected float mTouchDownX;
    protected float mTouchDownY;

    public MoveView(Context context) {
        this(context, null);
    }

    public MoveView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MoveView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateContainer();
        this.autoSide();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachWindow = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachWindow = false;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        boolean isFirst = this.mContainerRect.isEmpty();
        if (isFirst) {
            this.updateContainerAndSide();
        } else {
            this.updateContainer();
        }
    }

    public void updateSide(int side) {
        this.mSide = side;
        this.updateContainerAndSide();
    }

    protected void updateLayout(float deltaX, float deltaY) {
        this.setX(this.getX() + deltaX);
        this.setY(this.getY() + deltaY);
    }

    protected void updateContainer() {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (null == parent) {
            return;
        }
        parent.getHitRect(this.mContainerRect);
        this.mContainerPadding.set(parent.getPaddingLeft(), parent.getPaddingTop(), parent.getPaddingRight(), parent.getPaddingBottom());
    }

    protected void autoSide() {
        if (this.mSide == 0 || this.mContainerRect.isEmpty()) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        float currentX = this.getX();
        float currentY = this.getY();
        float newX = currentX;
        float newY = currentY;
        int maxX = this.mContainerRect.width() - this.mContainerPadding.right;
        int minX = this.mContainerPadding.left;
        int maxY = this.mContainerRect.height() - this.mContainerPadding.bottom;
        int minY = this.mContainerPadding.top;
        int centerX = maxX / 2 - width / 2;
        if (this.mSide == 1) {
            if (currentX + (float)width > (float)maxX) {
                newX = maxX - width;
            } else if (newX < (float)minX) {
                newX = minX;
            }
        } else if (this.mSide == 3) {
            if (currentX > (float)centerX) {
                newX = maxX - width;
            } else if (newX <= (float)centerX) {
                newX = minX;
            }
        }
        if (newY + (float)height > (float)maxY) {
            newY = maxY - height;
        } else if (newY < (float)minY) {
            newY = minY;
        }
        float deltaX = newX - currentX;
        float deltaY = newY - currentY;
        this.updateLayout(deltaX, deltaY);
    }

    public void show(Activity activity) {
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            Context context = this.getContext();
            if (context instanceof Activity && activity != context) {
                this.remove();
            } else {
                this.show();
                return;
            }
        }
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        View decorView = window.getDecorView();
        FrameLayout contentView = (FrameLayout)decorView.findViewById(0x1020002);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        contentView.addView((View)this, (ViewGroup.LayoutParams)params);
    }

    public void hide() {
        this.setVisibility(8);
    }

    protected void show() {
        this.setVisibility(0);
    }

    public void remove() {
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this);
        }
    }

    protected void updateContainerAndSide() {
        this.updateContainer();
        this.autoSide();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean ret = super.dispatchTouchEvent(ev);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        boolean ret = super.onInterceptTouchEvent(event);
        float x = event.getRawX();
        float y = event.getRawY();
        this.mTouchLastX = x;
        this.mTouchLastY = y;
        switch (event.getAction()) {
            case 0: {
                this.mTouchDownX = x;
                this.mTouchDownY = y;
                break;
            }
            case 2: {
                float deltaX = x - this.mTouchDownX;
                float deltaY = y - this.mTouchDownY;
                if (!(Math.abs(deltaX) >= (float)this.mTouchSlop) && !(Math.abs(deltaY) >= (float)this.mTouchSlop)) break;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getRawX();
        float y = event.getRawY();
        int action = event.getAction();
        if (action == 2) {
            float deltaX = x - this.mTouchLastX;
            float deltaY = y - this.mTouchLastY;
            this.updateLayout(deltaX, deltaY);
        } else if (action == 3 | action == 1) {
            this.autoSide();
        }
        this.mTouchLastX = x;
        this.mTouchLastY = y;
        return super.onTouchEvent(event);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SIDE {
    }
}

