/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.adapterview.loadmore;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.com.lasong.widget.R;
import cn.com.lasong.widget.adapterview.loadmore.LmRecyclerView;
import cn.com.lasong.widget.adapterview.loadmore.LoadMoreUIHandler;

public class LoadMoreDefaultFooterView
extends RelativeLayout
implements LoadMoreUIHandler {
    private TextView mTv;
    private ProgressBar mPb;

    public LoadMoreDefaultFooterView(Context context) {
        super(context);
        this.init();
    }

    public LoadMoreDefaultFooterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadMoreDefaultFooterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_load_more_default_footer, (ViewGroup)this);
        this.mTv = (TextView)this.findViewById(R.id.tv);
        this.mPb = (ProgressBar)this.findViewById(R.id.pb);
    }

    @Override
    public void onLoading(LmRecyclerView container) {
        this.setVisibility(0);
        this.mTv.setText(R.string.load_more_loading);
        this.mPb.setVisibility(0);
    }

    @Override
    public void onLoadFinish(LmRecyclerView container, boolean empty, boolean hasMore) {
        this.setVisibility(8);
    }

    @Override
    public void onWaitToLoadMore(LmRecyclerView container) {
        this.setVisibility(0);
        this.mTv.setText(R.string.load_more_wait_to_load);
        this.mPb.setVisibility(8);
    }

    @Override
    public void onLoadError(LmRecyclerView container, int errorCode, String errorMessage) {
        this.setVisibility(0);
        this.mTv.setText((CharSequence)errorMessage);
        this.mPb.setVisibility(8);
    }

    public void setFooterTextColor(int color) {
        this.mTv.setTextColor(color);
    }
}

