/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.shadow;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import cn.com.lasong.widget.R;
import cn.com.lasong.widget.shadow.ShadowView;

public class ShadowLayout
extends FrameLayout {
    private ShadowView shadowView = new ShadowView(this.getContext());

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadowLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        this.shadowView.bgColor = ta.getColor(R.styleable.ShadowLayout_bgColor, 0);
        this.shadowView.bgRadius = ta.getDimension(R.styleable.ShadowLayout_bgRadius, 0.0f);
        this.shadowView.mPaint.setColor(this.shadowView.bgColor);
        this.shadowView.dx = ta.getDimension(R.styleable.ShadowLayout_shadowDx, 0.0f);
        this.shadowView.dy = ta.getDimension(R.styleable.ShadowLayout_shadowDy, 0.0f);
        this.shadowView.shadowColor = ta.getColor(R.styleable.ShadowLayout_shadowColor, 0);
        this.shadowView.shadowRadius = ta.getDimension(R.styleable.ShadowLayout_shadowRadius, 0.0f);
        ta.recycle();
        FrameLayout.LayoutParams lp = this.generateDefaultLayoutParams();
        lp.width = 0;
        lp.height = 0;
        int margin = -((int)this.shadowView.shadowRadius);
        lp.setMargins(margin, margin, margin, margin);
        this.shadowView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView(this.shadowView, 0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setClipChildren(false);
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).setClipChildren(false);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (null != this.shadowView) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.shadowView.getLayoutParams();
            if (null == lp) {
                lp = this.generateDefaultLayoutParams();
            }
            lp.width = (int)((float)(right - left) + this.shadowView.shadowRadius * 2.0f);
            lp.height = (int)((float)(bottom - top) + this.shadowView.shadowRadius * 2.0f);
            int margin = -((int)this.shadowView.shadowRadius);
            lp.setMargins(margin, margin, margin, margin);
            this.shadowView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }
}

